/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery;

import java.net.URI;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.multicast.MulticastDiscoveryAgentFactory;
import org.apache.activemq.util.SocketProxy;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.CustomAction;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class DiscoveryNetworkReconnectTest {
    private static final Log LOG = LogFactory.getLog(DiscoveryNetworkReconnectTest.class);
    final int maxReconnects = 5;
    final String groupName = "GroupID-DiscoveryNetworkReconnectTest";
    final String discoveryAddress = "multicast://default?group=GroupID-DiscoveryNetworkReconnectTest&initialReconnectDelay=1000";
    final Semaphore mbeanRegistered = new Semaphore(0);
    final Semaphore mbeanUnregistered = new Semaphore(0);
    BrokerService brokerA;
    BrokerService brokerB;
    Mockery context;
    ManagementContext managementContext;
    DiscoveryAgent agent;
    SocketProxy proxy;

    @Before
    public void setUp() throws Exception {
        this.context = new JUnit4Mockery(){
            {
                this.setImposteriser(ClassImposteriser.INSTANCE);
            }
        };
        this.brokerA = new BrokerService();
        this.brokerA.setBrokerName("BrokerA");
        this.configure(this.brokerA);
        this.brokerA.addConnector("tcp://localhost:0");
        this.brokerA.start();
        this.brokerA.waitUntilStarted();
        this.proxy = new SocketProxy(((TransportConnector)this.brokerA.getTransportConnectors().get(0)).getConnectUri());
        this.managementContext = (ManagementContext)this.context.mock(ManagementContext.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).getJmxDomainName();
                this.will(2.returnValue((Object)"Test"));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).start();
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).isCreateConnector();
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).stop();
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).isConnectorStarted();
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).registerMBean(this.with(2.any(Object.class)), (ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=Broker"))));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).registerMBean(this.with(2.any(Object.class)), (ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=NetworkConnector,NetworkConnectorName=localhost"))));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).registerMBean(this.with(2.any(Object.class)), (ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=Topic,Destination=ActiveMQ.Advisory.Connection"))));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).registerMBean(this.with(2.any(Object.class)), (ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=jobScheduler,jobSchedulerName=JMS"))));
                ((ManagementContext)this.atLeast(4).of((Object)DiscoveryNetworkReconnectTest.this.managementContext)).registerMBean(this.with(2.any(Object.class)), (ObjectName)this.with((Matcher)new NetworkBridgeObjectNameMatcher<ObjectName>(new ObjectName("Test:BrokerName=BrokerNC,Type=NetworkBridge,NetworkConnectorName=localhost,Name=localhost/127.0.0.1_" + DiscoveryNetworkReconnectTest.this.proxy.getUrl().getPort()))));
                this.will((Action)new CustomAction("signal register network mbean"){

                    public Object invoke(Invocation invocation) throws Throwable {
                        LOG.info((Object)("Mbean Registered: " + invocation.getParameter(0)));
                        DiscoveryNetworkReconnectTest.this.mbeanRegistered.release();
                        return new ObjectInstance((ObjectName)invocation.getParameter(0), "dscription");
                    }
                });
                ((ManagementContext)this.atLeast(4).of((Object)DiscoveryNetworkReconnectTest.this.managementContext)).unregisterMBean((ObjectName)this.with((Matcher)new NetworkBridgeObjectNameMatcher<ObjectName>(new ObjectName("Test:BrokerName=BrokerNC,Type=NetworkBridge,NetworkConnectorName=localhost,Name=localhost/127.0.0.1_" + DiscoveryNetworkReconnectTest.this.proxy.getUrl().getPort()))));
                this.will((Action)new CustomAction("signal unregister network mbean"){

                    public Object invoke(Invocation invocation) throws Throwable {
                        LOG.info((Object)("Mbean Unregistered: " + invocation.getParameter(0)));
                        DiscoveryNetworkReconnectTest.this.mbeanUnregistered.release();
                        return null;
                    }
                });
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).unregisterMBean((ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=Broker"))));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).unregisterMBean((ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=NetworkConnector,NetworkConnectorName=localhost"))));
                ((ManagementContext)this.allowing(DiscoveryNetworkReconnectTest.this.managementContext)).unregisterMBean((ObjectName)this.with(2.equal((Object)new ObjectName("Test:BrokerName=BrokerNC,Type=Topic,Destination=ActiveMQ.Advisory.Connection"))));
            }
        });
        this.brokerB = new BrokerService();
        this.brokerB.setManagementContext(this.managementContext);
        this.brokerB.setBrokerName("BrokerNC");
        this.configure(this.brokerB);
    }

    @After
    public void tearDown() throws Exception {
        this.brokerA.stop();
        this.brokerA.waitUntilStopped();
        this.brokerB.stop();
        this.brokerB.waitUntilStopped();
        this.proxy.close();
    }

    private void configure(BrokerService broker) {
        broker.setPersistent(false);
        broker.setUseJmx(true);
    }

    @Test
    public void testMulicastReconnect() throws Exception {
        this.agent = MulticastDiscoveryAgentFactory.createDiscoveryAgent((URI)new URI("multicast://default?group=GroupID-DiscoveryNetworkReconnectTest&initialReconnectDelay=1000"));
        this.agent.registerService(this.proxy.getUrl().toString());
        this.agent.start();
        this.brokerB.addNetworkConnector("multicast://default?group=GroupID-DiscoveryNetworkReconnectTest&initialReconnectDelay=1000&wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000");
        this.brokerB.start();
        this.brokerB.waitUntilStarted();
        this.doReconnect();
    }

    @Test
    public void testSimpleReconnect() throws Exception {
        this.brokerB.addNetworkConnector("simple://(" + this.proxy.getUrl() + ")?useExponentialBackOff=false&initialReconnectDelay=500&wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000");
        this.brokerB.start();
        this.brokerB.waitUntilStarted();
        this.doReconnect();
    }

    private void doReconnect() throws Exception {
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((String)"we got a network connection in a timely manner", (boolean)Wait.waitFor(new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return DiscoveryNetworkReconnectTest.this.proxy.connections.size() >= 1;
                }
            }));
            Assert.assertTrue((String)"network connector mbean registered within 3 minute", (boolean)this.mbeanRegistered.tryAcquire(180L, TimeUnit.SECONDS));
            this.proxy.pause();
            Assert.assertTrue((String)"network connector mbean unregistered within 3 minute", (boolean)this.mbeanUnregistered.tryAcquire(180L, TimeUnit.SECONDS));
            this.proxy.close();
            this.proxy.reopen();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NetworkBridgeObjectNameMatcher<T>
    extends BaseMatcher<T> {
        T name;

        NetworkBridgeObjectNameMatcher(T o) {
            this.name = o;
        }

        public boolean matches(Object arg0) {
            ObjectName other = (ObjectName)arg0;
            ObjectName mine = (ObjectName)this.name;
            return other.getKeyProperty("Type").equals(mine.getKeyProperty("Type")) && other.getKeyProperty("NetworkConnectorName").equals(mine.getKeyProperty("NetworkConnectorName"));
        }

        public void describeTo(Description arg0) {
            arg0.appendText(((Object)((Object)this)).getClass().getName());
        }
    }
}

