/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.TransactionId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FailoverConsumerOutstandingCommitTest {
    private static final Log LOG = LogFactory.getLog(FailoverConsumerOutstandingCommitTest.class);
    private static final String QUEUE_NAME = "FailoverWithOutstandingCommit";
    private static final String MESSAGE_TEXT = "Test message ";
    private String url = "tcp://localhost:61616";
    final int prefetch = 10;
    BrokerService broker;

    public void startCleanBroker() throws Exception {
        this.startBroker(true);
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(this.url);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setOptimizedDispatch(true);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        return this.broker;
    }

    @Test
    public void testFailoverConsumerDups() throws Exception {
        this.doTestFailoverConsumerDups(true);
    }

    public void doTestFailoverConsumerDups(boolean watchTopicAdvisories) throws Exception {
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                context.setDontSendReponse(true);
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    public void run() {
                        LOG.info((Object)"Stopping broker before commit...");
                        try {
                            FailoverConsumerOutstandingCommitTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(watchTopicAdvisories);
        cf.setDispatchAsync(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session producerSession = connection.createSession(false, 1);
        final Queue destination = producerSession.createQueue("FailoverWithOutstandingCommit?consumer.prefetchSize=10");
        final Session consumerSession = connection.createSession(true, 1);
        final CountDownLatch commitDoneLatch = new CountDownLatch(1);
        final CountDownLatch messagesReceived = new CountDownLatch(2);
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        testConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info((Object)"consume one and commit");
                Assert.assertNotNull((String)"got message", (Object)message);
                try {
                    consumerSession.commit();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                commitDoneLatch.countDown();
                messagesReceived.countDown();
                LOG.info((Object)"done commit");
            }
        });
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                LOG.info((Object)"producer started");
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(producerSession, destination, 20L);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    Assert.fail((String)("unexpceted ex on producer: " + (Object)((Object)e)));
                }
                LOG.info((Object)"producer done");
            }
        });
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false);
        this.broker.start();
        Assert.assertTrue((String)"consumer added through failover", (boolean)commitDoneLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"another message was recieved after failover", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        connection.close();
    }

    @Test
    public void TestFailoverConsumerOutstandingSendTxIncomplete() throws Exception {
        this.doTestFailoverConsumerOutstandingSendTx(false);
    }

    @Test
    public void TestFailoverConsumerOutstandingSendTxComplete() throws Exception {
        this.doTestFailoverConsumerOutstandingSendTx(true);
    }

    public void doTestFailoverConsumerOutstandingSendTx(final boolean doActualBrokerCommit) throws Exception {
        boolean watchTopicAdvisories = true;
        this.broker = this.createBroker(true);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
                if (doActualBrokerCommit) {
                    LOG.info((Object)"doing actual broker commit...");
                    super.commitTransaction(context, xid, onePhase);
                }
                context.setDontSendReponse(true);
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    public void run() {
                        LOG.info((Object)"Stopping broker before commit...");
                        try {
                            FailoverConsumerOutstandingCommitTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(true);
        cf.setDispatchAsync(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        final Session producerSession = connection.createSession(false, 1);
        final Queue destination = producerSession.createQueue("FailoverWithOutstandingCommit?consumer.prefetchSize=10");
        final Queue signalDestination = producerSession.createQueue("FailoverWithOutstandingCommit.signal?consumer.prefetchSize=10");
        final Session consumerSession = connection.createSession(true, 0);
        final CountDownLatch commitDoneLatch = new CountDownLatch(1);
        final CountDownLatch messagesReceived = new CountDownLatch(3);
        final AtomicBoolean gotCommitException = new AtomicBoolean(false);
        final ArrayList receivedMessages = new ArrayList();
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        testConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                LOG.info((Object)("consume one and commit: " + message));
                Assert.assertNotNull((String)"got message", (Object)message);
                receivedMessages.add((TextMessage)message);
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(consumerSession, signalDestination, 1L);
                    consumerSession.commit();
                }
                catch (JMSException e) {
                    LOG.info((Object)"commit exception", (Throwable)e);
                    gotCommitException.set(true);
                }
                commitDoneLatch.countDown();
                messagesReceived.countDown();
                LOG.info((Object)"done commit");
            }
        });
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                LOG.info((Object)"producer started");
                try {
                    FailoverConsumerOutstandingCommitTest.this.produceMessage(producerSession, destination, 20L);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    Assert.fail((String)("unexpceted ex on producer: " + (Object)((Object)e)));
                }
                LOG.info((Object)"producer done");
            }
        });
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false);
        this.broker.start();
        Assert.assertTrue((String)"commit done through failover", (boolean)commitDoneLatch.await(20L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"commit failed", (boolean)gotCommitException.get());
        Assert.assertTrue((String)"another message was received after failover", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"get message 0 first", (Object)"Test message 0", (Object)((TextMessage)receivedMessages.get(0)).getText());
        Assert.assertEquals((String)"get message 0 second", (Object)"Test message 0", (Object)((TextMessage)receivedMessages.get(1)).getText());
        Assert.assertTrue((String)"another message was received", (boolean)messagesReceived.await(20L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"get message 1 eventually", (Object)"Test message 1", (Object)((TextMessage)receivedMessages.get(2)).getText());
        connection.close();
    }

    @Test
    public void testRollbackFailoverConsumerTx() throws Exception {
        this.broker = this.createBroker(true);
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setConsumerFailoverRedeliveryWaitPeriod(10000L);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session producerSession = connection.createSession(false, 1);
        Queue destination = producerSession.createQueue(QUEUE_NAME);
        Session consumerSession = connection.createSession(true, 0);
        MessageConsumer testConsumer = consumerSession.createConsumer((Destination)destination);
        Assert.assertNull((String)"no message yet", (Object)testConsumer.receiveNoWait());
        this.produceMessage(producerSession, destination, 1L);
        producerSession.close();
        Message msg = testConsumer.receive(5000L);
        Assert.assertNotNull((Object)msg);
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false);
        this.broker.start();
        consumerSession.rollback();
        msg = testConsumer.receive(10000L);
        Assert.assertNotNull((String)"got message again after rollback", (Object)msg);
        consumerSession.commit();
        consumerSession.close();
        msg = this.receiveMessage(cf, destination);
        Assert.assertNull((String)"should be nothing left after commit", (Object)msg);
        connection.close();
    }

    private Message receiveMessage(ActiveMQConnectionFactory cf, Queue destination) throws Exception {
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session consumerSession = connection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)destination);
        Message msg = consumer.receive(5000L);
        consumerSession.commit();
        connection.close();
        return msg;
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage(MESSAGE_TEXT + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }
}

