/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FailoverPrefetchZeroTest {
    private static final Log LOG = LogFactory.getLog(FailoverPrefetchZeroTest.class);
    private static final String QUEUE_NAME = "FailoverPrefetchZero";
    private String url = "tcp://localhost:61616";
    final int prefetch = 0;
    BrokerService broker;

    public void startCleanBroker() throws Exception {
        this.startBroker(true);
    }

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(this.url);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        return this.broker;
    }

    @Test
    public void testPrefetchZeroConsumerThroughRestart() throws Exception {
        this.broker = this.createBroker(true);
        final CountDownLatch pullDone = new CountDownLatch(1);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public Response messagePull(ConnectionContext context, final MessagePull pull) throws Exception {
                context.setDontSendReponse(true);
                pullDone.countDown();
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    public void run() {
                        LOG.info((Object)("Stopping broker on pull: " + pull));
                        try {
                            FailoverPrefetchZeroTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                return null;
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session consumerSession = connection.createSession(false, 1);
        Queue destination = consumerSession.createQueue("FailoverPrefetchZero?consumer.prefetchSize=0");
        final MessageConsumer consumer = consumerSession.createConsumer((Destination)destination);
        this.produceMessage(consumerSession, destination, 1L);
        final CountDownLatch receiveDone = new CountDownLatch(1);
        final Vector received = new Vector();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                try {
                    LOG.info((Object)"receive one...");
                    Message msg = consumer.receive(30000L);
                    if (msg != null) {
                        received.add(msg);
                    }
                    receiveDone.countDown();
                    LOG.info((Object)"done receive");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Assert.assertTrue((String)"pull completed on broker", (boolean)pullDone.await(30L, TimeUnit.SECONDS));
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false);
        this.broker.start();
        Assert.assertTrue((String)"receive completed through failover", (boolean)receiveDone.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"we got our message:", (!received.isEmpty() ? 1 : 0) != 0);
        connection.close();
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage("Test message " + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }
}

