/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.net.ServerSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;

public class SlowConnectionTest
extends TestCase {
    public void testSlowConnection() throws Exception {
        int timeout = 1000;
        URI tcpUri = new URI("tcp://localhost:61616?soTimeout=" + timeout + "&trace=true&connectionTimeout=" + timeout + "&wireFormat.maxInactivityDurationInitalDelay=" + timeout);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + tcpUri + ")");
        final Connection connection = cf.createConnection();
        MockBroker broker = new MockBroker();
        broker.start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    connection.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
        Thread.sleep(timeout * 5);
        int count = 0;
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().contains("ActiveMQ Transport")) continue;
            ++count;
        }
        broker.interrupt();
        broker.join();
        SlowConnectionTest.assertTrue((String)("Transport count: " + count + ", expected <= 1"), (count <= 1 ? 1 : 0) != 0);
    }

    class MockBroker
    extends Thread {
        MockBroker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<Socket> inProgress = new ArrayList<Socket>();
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            ServerSocket ss = null;
            try {
                ss = factory.createServerSocket(61616);
                while (!MockBroker.interrupted()) {
                    inProgress.add(ss.accept());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ss.close();
                }
                catch (IOException ignored) {}
                for (Socket s : inProgress) {
                    try {
                        s.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }
}

