/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.File;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StompAdvisoryTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(StompAdvisoryTest.class);
    protected ConnectionFactory factory;
    protected ActiveMQConnection connection;
    protected BrokerService broker;
    StompConnection stompConnection;
    URI tcpBrokerUri;
    URI stompBrokerUri;

    private PolicyEntry createPolicyEntry() {
        PolicyEntry policy = new PolicyEntry();
        policy.setAdvisdoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setProducerFlowControl(false);
        ConstantPendingMessageLimitStrategy strategy = new ConstantPendingMessageLimitStrategy();
        strategy.setLimit(10);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)strategy);
        return policy;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker://()/localhost?useJmx=false"));
        broker.setPersistent(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setAdvisdoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setProducerFlowControl(false);
        ConstantPendingMessageLimitStrategy strategy = new ConstantPendingMessageLimitStrategy();
        strategy.setLimit(10);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("tcp://localhost:0");
        broker.addConnector("stomp://localhost:0");
        return broker;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.broker = this.createBroker();
        this.broker.start();
        this.tcpBrokerUri = URISupport.removeQuery((URI)((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri());
        this.stompBrokerUri = URISupport.removeQuery((URI)((TransportConnector)this.broker.getTransportConnectors().get(1)).getConnectUri());
        LOG.info((Object)("Producing using TCP uri: " + this.tcpBrokerUri));
        LOG.info((Object)("consuming using STOMP uri: " + this.stompBrokerUri));
        this.stompConnection = new StompConnection();
        this.stompConnection.open(new Socket("localhost", this.stompBrokerUri.getPort()));
    }

    protected void tearDown() throws Exception {
        this.stompConnection.disconnect();
        this.stompConnection.close();
        this.broker.stop();
    }

    public void testConnectionAdvisory() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testConnectionAdvisory");
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Connection", "auto");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ConnectionInfo\":"));
        Map headers = f.getHeaders();
        c.stop();
        c.close();
        f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertNotNull((String)"Body is not null", (Object)f.getBody());
        StompAdvisoryTest.assertTrue((String)"Body should have content", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ConnectionInfo\":"));
    }

    public void testConnectionAdvisoryJSON() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testConnectionAdvisory");
        HashMap<String, String> subheaders = new HashMap<String, String>(1);
        subheaders.put("transformation", Stomp.Transformations.JMS_JSON.toString());
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Connection", "auto", subheaders);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ConnectionInfo\":"));
        Map headers = f.getHeaders();
        c.stop();
        c.close();
        f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertNotNull((String)"Body is not null", (Object)f.getBody());
        StompAdvisoryTest.assertTrue((String)"Body should have content", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ConnectionInfo\":"));
    }

    public void testConnectionAdvisoryXML() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testConnectionAdvisory");
        HashMap<String, String> subheaders = new HashMap<String, String>(1);
        subheaders.put("transformation", Stomp.Transformations.JMS_XML.toString());
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Connection", "auto", subheaders);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("<ConnectionInfo>"));
        Map headers = f.getHeaders();
        c.stop();
        c.close();
        f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertNotNull((String)"Body is not null", (Object)f.getBody());
        StompAdvisoryTest.assertTrue((String)"Body should have content", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("<ConnectionInfo>"));
    }

    public void testConsumerAdvisory() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testConsumerAdvisory");
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Consumer.>", "auto");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        Session session = c.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ConsumerInfo\":"));
        c.stop();
        c.close();
    }

    public void testProducerAdvisory() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testProducerAdvisory");
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Producer.>", "auto");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        Session session = c.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)dest);
        TextMessage mess = session.createTextMessage("test");
        producer.send((Message)mess);
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ProducerInfo\":"));
        c.stop();
        c.close();
    }

    public void testProducerAdvisoryXML() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testProducerAdvisoryXML");
        HashMap<String, String> subheaders = new HashMap<String, String>(1);
        subheaders.put("transformation", Stomp.Transformations.JMS_ADVISORY_XML.toString());
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Producer.>", "auto", subheaders);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        Session session = c.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)dest);
        TextMessage mess = session.createTextMessage("test");
        producer.send((Message)mess);
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("<ProducerInfo>"));
        c.stop();
        c.close();
    }

    public void testProducerAdvisoryJSON() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue("testProducerAdvisoryJSON");
        HashMap<String, String> subheaders = new HashMap<String, String>(1);
        subheaders.put("transformation", Stomp.Transformations.JMS_ADVISORY_JSON.toString());
        this.stompConnection.connect("system", "manager");
        this.stompConnection.subscribe("/topic/ActiveMQ.Advisory.Producer.>", "auto", subheaders);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.tcpBrokerUri);
        Connection c = factory.createConnection();
        c.start();
        Session session = c.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)dest);
        TextMessage mess = session.createTextMessage("test");
        producer.send((Message)mess);
        StompFrame f = this.stompConnection.receive();
        LOG.debug((Object)f);
        StompAdvisoryTest.assertEquals((String)f.getAction(), (String)"MESSAGE");
        StompAdvisoryTest.assertTrue((String)"Should have a body", (f.getBody().length() > 0 ? 1 : 0) != 0);
        StompAdvisoryTest.assertTrue((boolean)f.getBody().startsWith("{\"ProducerInfo\":"));
        c.stop();
        c.close();
    }
}

