/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSocketTstFactory
extends ServerSocketFactory {
    private static final Log LOG = LogFactory.getLog(ServerSocketTstFactory.class);
    private final Random rnd;
    private static final ServerSocketTstFactory server = new ServerSocketTstFactory();

    public ServerSocketTstFactory() {
        LOG.info((Object)"Creating a new ServerSocketTstFactory");
        this.rnd = new Random();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocketTst sSock = new ServerSocketTst(port, this.rnd);
        return sSock.getSocket();
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocketTst sSock = new ServerSocketTst(port, backlog, this.rnd);
        return sSock.getSocket();
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocketTst sSock = new ServerSocketTst(port, backlog, ifAddress, this.rnd);
        return sSock.getSocket();
    }

    public static ServerSocketTstFactory getDefault() {
        return server;
    }

    private class ServerSocketTst {
        private final ServerSocket socket;

        public ServerSocketTst(int port, Random rnd) throws IOException {
            this.socket = ServerSocketFactory.getDefault().createServerSocket(port);
        }

        public ServerSocketTst(int port, int backlog, Random rnd) throws IOException {
            this.socket = ServerSocketFactory.getDefault().createServerSocket(port, backlog);
        }

        public ServerSocketTst(int port, int backlog, InetAddress bindAddr, Random rnd) throws IOException {
            this.socket = ServerSocketFactory.getDefault().createServerSocket(port, backlog, bindAddr);
        }

        public ServerSocket getSocket() {
            return this.socket;
        }
    }
}

