/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLServerSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.transport.tcp.SslTransportServer;
import org.apache.activemq.transport.tcp.StubSSLServerSocket;
import org.apache.activemq.transport.tcp.StubSSLSocketFactory;

public class SslTransportServerTest
extends TestCase {
    private SslTransportServer sslTransportServer;
    private StubSSLServerSocket sslServerSocket;

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createAndBindTransportServer(boolean wantClientAuth, boolean needClientAuth, String options) throws IOException {
        this.sslServerSocket = new StubSSLServerSocket();
        StubSSLSocketFactory socketFactory = new StubSSLSocketFactory(this.sslServerSocket);
        try {
            this.sslTransportServer = new SslTransportServer(null, new URI("ssl://localhost:61616?" + options), (SSLServerSocketFactory)socketFactory);
        }
        catch (Exception e) {
            SslTransportServerTest.fail((String)"Unable to create SslTransportServer.");
        }
        this.sslTransportServer.setWantClientAuth(wantClientAuth);
        this.sslTransportServer.setNeedClientAuth(needClientAuth);
        this.sslTransportServer.bind();
    }

    public void testWantAndNeedClientAuthSetters() throws IOException {
        for (int i = 0; i < 4; ++i) {
            String options = "";
            this.singleTest(i, options);
        }
    }

    public void testWantAndNeedAuthReflection() throws IOException {
        for (int i = 0; i < 4; ++i) {
            String options = "wantClientAuth=" + (this.getWantClientAuth(i) ? "true" : "false") + "&needClientAuth=" + (this.getNeedClientAuth(i) ? "true" : "false");
            this.singleTest(i, options);
        }
    }

    private void singleTest(int i, String options) throws IOException {
        boolean wantClientAuth = this.getWantClientAuth(i);
        boolean needClientAuth = this.getNeedClientAuth(i);
        int expectedWantStatus = needClientAuth ? -1 : (wantClientAuth ? 1 : -1);
        int expectedNeedStatus = needClientAuth ? 1 : -1;
        this.createAndBindTransportServer(wantClientAuth, needClientAuth, options);
        SslTransportServerTest.assertEquals((String)("Created ServerSocket did not have correct wantClientAuth status. wantClientAuth: " + wantClientAuth + ", needClientAuth: " + needClientAuth), (int)expectedWantStatus, (int)this.sslServerSocket.getWantClientAuthStatus());
        SslTransportServerTest.assertEquals((String)("Created ServerSocket did not have correct needClientAuth status. wantClientAuth: " + wantClientAuth + ", needClientAuth: " + needClientAuth), (int)expectedNeedStatus, (int)this.sslServerSocket.getNeedClientAuthStatus());
    }

    private boolean getNeedClientAuth(int i) {
        return (i & 2) == 2;
    }

    private boolean getWantClientAuth(int i) {
        return (i & 1) == 1;
    }
}

