/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.tcp.ServerSocketTstFactory;
import org.apache.activemq.transport.tcp.SocketTstFactory;
import org.apache.activemq.transport.tcp.TcpFaultyTransport;
import org.apache.activemq.transport.tcp.TcpFaultyTransportServer;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpFaultyTransportFactory
extends TcpTransportFactory {
    private static final Log LOG = LogFactory.getLog(TcpFaultyTransportFactory.class);

    protected TcpFaultyTransport createTcpFaultyTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new TcpFaultyTransport(wf, socketFactory, location, localLocation);
    }

    protected Transport createTransport(URI location, WireFormat wf) throws UnknownHostException, IOException {
        URI localLocation = null;
        String path = location.getPath();
        if (path != null && path.length() > 0) {
            int localPortIndex = path.indexOf(58);
            try {
                Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                String localString = location.getScheme() + ":/" + path;
                localLocation = new URI(localString);
            }
            catch (Exception e) {
                LOG.warn((Object)"path isn't a valid local location for TcpTransport to use", (Throwable)e);
            }
        }
        SocketFactory socketFactory = this.createSocketFactory();
        return this.createTcpFaultyTransport(wf, socketFactory, location, localLocation);
    }

    protected TcpFaultyTransportServer createTcpFaultyTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpFaultyTransportServer(this, location, serverSocketFactory);
    }

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParameters((URI)location));
            ServerSocketFactory serverSocketFactory = this.createServerSocketFactory();
            TcpFaultyTransportServer server = this.createTcpFaultyTransportServer(location, serverSocketFactory);
            server.setWireFormatFactory(this.createWireFormatFactory(options));
            IntrospectionSupport.setProperties((Object)((Object)server), options);
            Map transportOptions = IntrospectionSupport.extractProperties(options, (String)"transport.");
            server.setTransportOption(transportOptions);
            server.bind();
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    protected SocketFactory createSocketFactory() throws IOException {
        return SocketTstFactory.getDefault();
    }

    protected ServerSocketFactory createServerSocketFactory() throws IOException {
        return ServerSocketTstFactory.getDefault();
    }
}

