/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;

public class VmTransportNetworkBrokerTest
extends TestCase {
    private static final String VM_BROKER_URI = "vm://localhost?create=false";
    CountDownLatch started = new CountDownLatch(1);
    CountDownLatch gotConnection = new CountDownLatch(1);

    public void testNoThreadLeakWithActiveVMConnection() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDedicatedTaskRunner(true);
        broker.setPersistent(false);
        broker.addConnector("tcp://localhost:61616");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://wrongHostname1:61617,tcp://wrongHostname2:61618)?useExponentialBackOff=false");
        networkConnector.setDuplex(true);
        broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI));
        cf.createConnection("system", "manager").start();
        TimeUnit.SECONDS.sleep(5L);
        int threadCount = Thread.activeCount();
        TimeUnit.SECONDS.sleep(30L);
        int threadCountAfterSleep = Thread.activeCount();
        VmTransportNetworkBrokerTest.assertTrue((String)("Threads are leaking, threadCount=" + threadCount + " threadCountAfterSleep=" + threadCountAfterSleep), (threadCountAfterSleep < threadCount + 8 ? 1 : 0) != 0);
        broker.stop();
    }
}

