/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.QueueBrowser;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.region.QueueSubscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class BrowseOverNetworkTest
extends JmsMultipleBrokersTestSupport {
    private static final Log LOG = LogFactory.getLog(QueueSubscription.class);
    protected static final int MESSAGE_COUNT = 10;

    public void testBrowse() throws Exception {
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("BrokerA", (Destination)dest, 10);
        Thread.sleep(1000L);
        int browsed = this.browseMessages("BrokerB", (Destination)dest);
        Thread.sleep(1000L);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        msgsA.waitForMessagesToArrive(10);
        Thread.sleep(1000L);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        msgsB.waitForMessagesToArrive(10);
        LOG.info((Object)("A+B: " + msgsA.getMessageCount() + "+" + msgsB.getMessageCount()));
        BrowseOverNetworkTest.assertEquals((String)"Consumer on Broker A, should've consumed all messages", (int)10, (int)msgsA.getMessageCount());
        BrowseOverNetworkTest.assertEquals((String)"Broker B shouldn't get any messages", (int)0, (int)browsed);
    }

    public void testConsumerInfo() throws Exception {
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker1.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker2.xml"));
        this.startAllBrokers();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker1")).broker.waitUntilStarted();
        ActiveMQDestination dest = this.createDestination("QUEUE.A,QUEUE.B", false);
        int broker1 = this.browseMessages("broker1", (Destination)dest);
        BrowseOverNetworkTest.assertEquals((String)"Browsed a message on an empty queue", (int)0, (int)broker1);
        Thread.sleep(1000L);
        int broker2 = this.browseMessages("broker2", (Destination)dest);
        BrowseOverNetworkTest.assertEquals((String)"Browsed a message on an empty queue", (int)0, (int)broker2);
    }

    protected NetworkConnector bridgeBrokersWithIncludedDestination(String localBrokerName, String remoteBrokerName, ActiveMQDestination included, ActiveMQDestination excluded) throws Exception {
        NetworkConnector nc = this.bridgeBrokers(localBrokerName, remoteBrokerName, false, 4, true);
        nc.addStaticallyIncludedDestination(included);
        if (excluded != null) {
            nc.addExcludedDestination(excluded);
        }
        nc.setPrefetchSize(1);
        return nc;
    }

    public void testAMQ3020() throws Exception {
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker1A.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker1B.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker2A.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker2B.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker3A.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/browse-broker3B.xml"));
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-1A")).broker.waitUntilStarted();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-2A")).broker.waitUntilStarted();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-3A")).broker.waitUntilStarted();
        ActiveMQDestination composite = this.createDestination("PROD.FUSESOURCE.3.A,PROD.FUSESOURCE.3.B", false);
        Browser browser1 = new Browser("broker-3A", (Destination)composite);
        browser1.start();
        Thread.sleep(1000L);
        Browser browser2 = new Browser("broker-3B", (Destination)composite);
        browser2.start();
        Thread.sleep(1000L);
        this.sendMessages("broker-1A", (Destination)composite, 10);
        browser1.join();
        browser2.join();
        LOG.info((Object)("broker-3A browsed " + browser1.getTotalCount()));
        LOG.info((Object)("broker-3B browsed " + browser2.getTotalCount()));
        BrowseOverNetworkTest.assertEquals((int)20, (int)(browser1.getTotalCount() + browser2.getTotalCount()));
    }

    protected int browseMessages(QueueBrowser browser, String name) throws Exception {
        Enumeration msgs = browser.getEnumeration();
        int browsedMessage = 0;
        while (msgs.hasMoreElements()) {
            ++browsedMessage;
            ActiveMQTextMessage message = (ActiveMQTextMessage)msgs.nextElement();
            LOG.info((Object)(name + " browsed: " + message.getText() + " " + message.getDestination() + " " + message.getMessageId() + " " + Arrays.toString(message.getBrokerPath())));
        }
        return browsedMessage;
    }

    protected int browseMessages(String broker, Destination dest) throws Exception {
        QueueBrowser browser = this.createBrowser(broker, dest);
        int browsedMessage = this.browseMessages(browser, "browser");
        browser.close();
        return browsedMessage;
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    public class Browser
    extends Thread {
        String broker;
        Destination dest;
        int totalCount;
        QueueBrowser browser = null;
        MessageConsumer consumer = null;
        boolean consume = false;

        public Browser(String broker, Destination dest) {
            this.broker = broker;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int retries = 0;
            while (retries++ < 5) {
                try {
                    QueueBrowser browser = BrowseOverNetworkTest.this.createBrowser(this.broker, this.dest);
                    int count = BrowseOverNetworkTest.this.browseMessages(browser, this.broker);
                    if (this.consume) {
                        if (count != 0) {
                            MessageConsumer consumer = BrowseOverNetworkTest.this.createSyncConsumer(this.broker, this.dest);
                            this.totalCount += count;
                            for (int i = 0; i < count; ++i) {
                                ActiveMQTextMessage message = (ActiveMQTextMessage)consumer.receive(1000L);
                                LOG.info((Object)(this.broker + " consumer: " + message.getText() + " " + message.getDestination() + " " + message.getMessageId() + " " + Arrays.toString(message.getBrokerPath())));
                                if (message != null) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        this.totalCount = count;
                    }
                    LOG.info((Object)("browser '" + this.broker + "' browsed " + this.totalCount));
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOG.info((Object)("Exception browsing " + e), (Throwable)e);
                }
                finally {
                    try {
                        if (this.browser != null) {
                            this.browser.close();
                        }
                        if (this.consumer == null) continue;
                        this.consumer.close();
                    }
                    catch (Exception e) {
                        LOG.info((Object)("Exception closing browser " + e), (Throwable)e);
                    }
                }
            }
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }
}

