/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Vector;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableSubscriptionOfflineTest
extends TestSupport {
    private static final Log LOG = LogFactory.getLog(DurableSubscriptionOfflineTest.class);
    public Boolean usePrioritySupport = Boolean.TRUE;
    private BrokerService broker;
    private ActiveMQTopic topic;
    private Vector<Exception> exceptions = new Vector();
    private static String filter = "$a='A1' AND (($b=true AND $c=true) OR ($d='D1' OR $d='D2'))";

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName(true));
    }

    protected Connection createConnection() throws Exception {
        return this.createConnection("cliName");
    }

    protected Connection createConnection(String name) throws Exception {
        Connection con = super.createConnection();
        con.setClientID(name);
        con.start();
        return con;
    }

    public static Test suite() {
        return DurableSubscriptionOfflineTest.suite(DurableSubscriptionOfflineTest.class);
    }

    protected void setUp() throws Exception {
        this.exceptions.clear();
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.createBroker(true);
    }

    private void createBroker(boolean deleteAllMessages) throws Exception {
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + this.getName(true) + ")"));
        this.broker.setBrokerName(this.getName(true));
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.broker.getManagementContext().setCreateConnector(false);
        if (this.usePrioritySupport.booleanValue()) {
            PolicyEntry policy = new PolicyEntry();
            policy.setPrioritizedMessages(true);
            PolicyMap policyMap = new PolicyMap();
            policyMap.setDefaultEntry(policy);
            this.broker.setDestinationPolicy(policyMap);
        }
        this.setDefaultPersistenceAdapter(this.broker);
        if (this.broker.getPersistenceAdapter() instanceof JDBCPersistenceAdapter) {
            ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).setCleanupPeriod(2000);
        }
        this.broker.start();
    }

    private void destroyBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void initCombosForTestConsumeOnlyMatchedMessages() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
        this.addCombinationValues("usePrioritySupport", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testConsumeOnlyMatchedMessages() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            boolean filter;
            boolean bl = filter = i % 2 == 1;
            if (filter) {
                ++sent;
            }
            Message message = session.createMessage();
            message.setStringProperty("filter", filter ? "true" : "false");
            producer.send((Destination)this.topic, message);
        }
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener.count);
    }

    public void testConsumeAllMatchedMessages() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener.count);
    }

    public void initCombosForTestVerifyAllConsumedAreAcked() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
        this.addCombinationValues("usePrioritySupport", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testVerifyAllConsumedAreAcked() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        LOG.info((Object)("Consumed: " + listener.count));
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener.count);
        con = this.createConnection();
        session = con.createSession(false, 1);
        consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((int)0, (int)listener.count);
    }

    public void testTwoOfflineSubscriptionCanConsume() throws Exception {
        Connection con = this.createConnection("cliId1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        Connection con2 = this.createConnection("cliId2");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener2 = new Listener();
        consumer2.setMessageListener((MessageListener)listener2);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        session2.close();
        con2.close();
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener2.count);
        con = this.createConnection("cliId1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((String)"offline consumer got all", (int)sent, (int)listener.count);
    }

    public void initCombosForTestOfflineSubscriptionCanConsumeAfterOnlineSubs() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
        this.addCombinationValues("usePrioritySupport", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testOfflineSubscriptionCanConsumeAfterOnlineSubs() throws Exception {
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        Connection con2 = this.createConnection("onlineCli1");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener2 = new Listener();
        consumer2.setMessageListener((MessageListener)listener2);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        session2.close();
        con2.close();
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener2.count);
        this.broker.stop();
        this.createBroker(false);
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Connection con3 = this.createConnection("offCli2");
        Session session3 = con3.createSession(false, 1);
        TopicSubscriber consumer3 = session3.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        Listener listener3 = new Listener();
        consumer3.setMessageListener((MessageListener)listener3);
        Thread.sleep(3000L);
        session.close();
        con.close();
        session3.close();
        con3.close();
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener.count);
        DurableSubscriptionOfflineTest.assertEquals((int)sent, (int)listener3.count);
    }

    public void initCombosForTestInterleavedOfflineSubscriptionCanConsume() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
    }

    public void testInterleavedOfflineSubscriptionCanConsume() throws Exception {
        Connection con = this.createConnection("cliId1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        Connection con2 = this.createConnection("cliId2");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener2 = new Listener();
        consumer2.setMessageListener((MessageListener)listener2);
        DurableSubscriptionOfflineTest.assertEquals((int)0, (int)listener2.count);
        session2.close();
        con2.close();
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        con2 = this.createConnection("cliId2");
        session2 = con2.createSession(false, 1);
        consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        listener2 = new Listener("cliId2");
        consumer2.setMessageListener((MessageListener)listener2);
        Thread.sleep(3000L);
        DurableSubscriptionOfflineTest.assertEquals((int)10, (int)listener2.count);
        con = this.createConnection("cliId1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Listener listener = new Listener("cliId1");
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((String)"offline consumer got all", (int)sent, (int)listener.count);
    }

    public void x_initCombosForTestMixOfOnLineAndOfflineSubsGetAllMatched() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, TestSupport.PersistenceAdapterChoice.JDBC});
    }

    public void testMixOfOnLineAndOfflineSubsGetAllMatched() throws Exception {
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        session.close();
        con.close();
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        session.close();
        con.close();
        Connection con2 = this.createConnection("onlineCli1");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        Listener listener2 = new Listener();
        consumer2.setMessageListener((MessageListener)listener2);
        Connection con4 = this.createConnection("nondurableCli");
        Session session4 = con4.createSession(false, 1);
        MessageConsumer consumer4 = session4.createConsumer((Destination)this.topic, filter, true);
        Listener listener4 = new Listener();
        consumer4.setMessageListener((MessageListener)listener4);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        boolean hasRelevant = false;
        int filtered = 0;
        for (int i = 0; i < 100; ++i) {
            int postf = (int)(Math.random() * 9.0) + 1;
            String d = "D" + postf;
            if ("D1".equals(d) || "D2".equals(d)) {
                hasRelevant = true;
                ++filtered;
            }
            Message message = session.createMessage();
            message.setStringProperty("$a", "A1");
            message.setStringProperty("$d", d);
            producer.send((Destination)this.topic, message);
        }
        Message message = session.createMessage();
        message.setStringProperty("$a", "A1");
        message.setBooleanProperty("$b", true);
        message.setBooleanProperty("$c", hasRelevant);
        producer.send((Destination)this.topic, message);
        if (hasRelevant) {
            ++filtered;
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        session4.close();
        con4.close();
        DurableSubscriptionOfflineTest.assertEquals((int)filtered, (int)listener4.count);
        session2.close();
        con2.close();
        DurableSubscriptionOfflineTest.assertEquals((int)filtered, (int)listener2.count);
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        FilterCheckListener listener = new FilterCheckListener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((int)filtered, (int)listener.count);
        Connection con3 = this.createConnection("offCli2");
        Session session3 = con3.createSession(false, 1);
        TopicSubscriber consumer3 = session3.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        FilterCheckListener listener3 = new FilterCheckListener();
        consumer3.setMessageListener((MessageListener)listener3);
        Thread.sleep(3000L);
        session3.close();
        con3.close();
        DurableSubscriptionOfflineTest.assertEquals((int)filtered, (int)listener3.count);
        DurableSubscriptionOfflineTest.assertTrue((String)("no unexpected exceptions: " + this.exceptions), (boolean)this.exceptions.isEmpty());
    }

    public void testRemovedDurableSubDeletes() throws Exception {
        Connection con = this.createConnection("cliId1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        Connection con2 = this.createConnection("cliId1");
        Session session2 = con2.createSession(false, 1);
        session2.unsubscribe("SubsId");
        session2.close();
        con2.close();
        this.topic = new ActiveMQTopic(this.topic.getPhysicalName() + "?consumer.retroactive=true");
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        Listener listener = new Listener();
        consumer.setMessageListener((MessageListener)listener);
        session.close();
        con.close();
        DurableSubscriptionOfflineTest.assertEquals((int)0, (int)listener.count);
    }

    public class FilterCheckListener
    extends Listener {
        public void onMessage(Message message) {
            ++this.count;
            try {
                Object b = message.getObjectProperty("$b");
                if (b != null) {
                    boolean c = message.getBooleanProperty("$c");
                    Assert.assertTrue((String)"", (boolean)c);
                } else {
                    String d = message.getStringProperty("$d");
                    Assert.assertTrue((String)"", ("D1".equals(d) || "D2".equals(d) ? 1 : 0) != 0);
                }
            }
            catch (JMSException e) {
                DurableSubscriptionOfflineTest.this.exceptions.add(e);
            }
        }
    }

    public static class Listener
    implements MessageListener {
        int count = 0;
        String id = null;

        Listener() {
        }

        Listener(String id) {
            this.id = id;
        }

        public void onMessage(Message message) {
            ++this.count;
            if (this.id != null) {
                try {
                    LOG.info((Object)(this.id + ", " + message.getJMSMessageID()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

