/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.ObjectName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpiredMessagesWithNoConsumerTest
extends CombinationTestSupport {
    private static final Log LOG = LogFactory.getLog(ExpiredMessagesWithNoConsumerTest.class);
    BrokerService broker;
    Connection connection;
    Session session;
    MessageProducer producer;
    public ActiveMQDestination destination = new ActiveMQQueue("test");
    public boolean optimizedDispatch = true;
    public PendingQueueMessageStoragePolicy pendingQueuePolicy;

    public static Test suite() {
        return ExpiredMessagesWithNoConsumerTest.suite(ExpiredMessagesWithNoConsumerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ExpiredMessagesWithNoConsumerTest.suite());
    }

    protected void createBrokerWithMemoryLimit() throws Exception {
        this.doCreateBroker(true);
    }

    protected void createBroker() throws Exception {
        this.doCreateBroker(false);
    }

    private void doCreateBroker(boolean memoryLimit) throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("localhost");
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector("tcp://localhost:61616");
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setOptimizedDispatch(this.optimizedDispatch);
        defaultEntry.setExpireMessagesPeriod(800L);
        defaultEntry.setMaxExpirePageSize(800);
        defaultEntry.setPendingQueuePolicy(this.pendingQueuePolicy);
        if (memoryLimit) {
            defaultEntry.setDeadLetterStrategy(null);
            defaultEntry.setMemoryLimit(200000L);
        }
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    public void initCombosForTestExpiredMessagesWithNoConsumer() {
        this.addCombinationValues("optimizedDispatch", new Object[]{Boolean.TRUE, Boolean.FALSE});
        this.addCombinationValues("pendingQueuePolicy", new Object[]{null, new VMPendingQueueMessageStoragePolicy(), new FilePendingQueueMessageStoragePolicy()});
    }

    public void testExpiredMessagesWithNoConsumer() throws Exception {
        this.createBrokerWithMemoryLimit();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.producer.setTimeToLive(1000L);
        this.connection.start();
        long sendCount = 2000L;
        final Thread producingThread = new Thread("Producing Thread"){

            public void run() {
                try {
                    int i = 0;
                    long tStamp = System.currentTimeMillis();
                    while ((long)i++ < 2000L) {
                        ExpiredMessagesWithNoConsumerTest.this.producer.send((Message)ExpiredMessagesWithNoConsumerTest.this.session.createTextMessage("test"));
                        if (i % 100 != 0) continue;
                        LOG.info((Object)("sent: " + i + " @ " + (System.currentTimeMillis() - tStamp) / 100L + "m/ms"));
                        tStamp = System.currentTimeMillis();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"producer completed within time", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                producingThread.join(1000L);
                return !producingThread.isAlive();
            }
        }));
        final DestinationViewMBean view = this.createView(this.destination);
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
                return 2000L == view.getExpiredCount();
            }
        });
        LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"All sent have expired", (long)2000L, (long)view.getExpiredCount());
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"memory usage goes to duck egg", (int)0, (int)view.getMemoryPercentUsage());
    }

    public void testExpiredMessagesWithVerySlowConsumer() throws Exception {
        this.createBroker();
        long queuePrefetch = 600L;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?jms.prefetchPolicy.queuePrefetch=600");
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 2);
        this.producer = this.session.createProducer((Destination)this.destination);
        int ttl = 4000;
        this.producer.setTimeToLive(4000L);
        long sendCount = 1500L;
        final CountDownLatch receivedOneCondition = new CountDownLatch(1);
        final CountDownLatch waitCondition = new CountDownLatch(1);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.info((Object)("Got my message: " + message));
                    receivedOneCondition.countDown();
                    waitCondition.await(60L, TimeUnit.SECONDS);
                    LOG.info((Object)("acking message: " + message));
                    message.acknowledge();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
            }
        });
        this.connection.start();
        final Thread producingThread = new Thread("Producing Thread"){

            public void run() {
                try {
                    int i = 0;
                    long tStamp = System.currentTimeMillis();
                    while ((long)i++ < 1500L) {
                        ExpiredMessagesWithNoConsumerTest.this.producer.send((Message)ExpiredMessagesWithNoConsumerTest.this.session.createTextMessage("test"));
                        if (i % 100 != 0) continue;
                        LOG.info((Object)("sent: " + i + " @ " + (System.currentTimeMillis() - tStamp) / 100L + "m/ms"));
                        tStamp = System.currentTimeMillis();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"got one message", (boolean)receivedOneCondition.await(20L, TimeUnit.SECONDS));
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"producer completed within time ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                producingThread.join(1000L);
                return !producingThread.isAlive();
            }
        }));
        final DestinationViewMBean view = this.createView(this.destination);
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"all dispatched up to default prefetch ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 600L == view.getDispatchCount();
            }
        }));
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"All sent have expired ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 1500L == view.getExpiredCount();
            }
        }));
        LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
        waitCondition.countDown();
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 299L == view.getInFlightCount();
            }
        });
        LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"inflight reduces to half prefetch minus single delivered message", (long)299L, (long)view.getInFlightCount());
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"size gets back to 0 ", (long)0L, (long)view.getQueueSize());
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"dequeues match sent/expired ", (long)1500L, (long)view.getDequeueCount());
        consumer.close();
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 0L == view.getInFlightCount();
            }
        });
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"inflight goes to zeor on close", (long)0L, (long)view.getInFlightCount());
        LOG.info((Object)("done: " + this.getName()));
    }

    public void testExpiredMessagesWithVerySlowConsumerCanContinue() throws Exception {
        this.createBroker();
        long queuePrefetch = 600L;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?jms.prefetchPolicy.queuePrefetch=600");
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 2);
        this.producer = this.session.createProducer((Destination)this.destination);
        int ttl = 4000;
        this.producer.setTimeToLive(4000L);
        long sendCount = 1500L;
        final CountDownLatch receivedOneCondition = new CountDownLatch(1);
        final CountDownLatch waitCondition = new CountDownLatch(1);
        final AtomicLong received = new AtomicLong();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.info((Object)("Got my message: " + message));
                    receivedOneCondition.countDown();
                    received.incrementAndGet();
                    waitCondition.await(60L, TimeUnit.SECONDS);
                    LOG.info((Object)("acking message: " + message));
                    message.acknowledge();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.toString());
                }
            }
        });
        this.connection.start();
        final Thread producingThread = new Thread("Producing Thread"){

            public void run() {
                try {
                    int i = 0;
                    long tStamp = System.currentTimeMillis();
                    while ((long)i++ < 1500L) {
                        ExpiredMessagesWithNoConsumerTest.this.producer.send((Message)ExpiredMessagesWithNoConsumerTest.this.session.createTextMessage("test"));
                        if (i % 100 != 0) continue;
                        LOG.info((Object)("sent: " + i + " @ " + (System.currentTimeMillis() - tStamp) / 100L + "m/ms"));
                        tStamp = System.currentTimeMillis();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        producingThread.start();
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"got one message", (boolean)receivedOneCondition.await(20L, TimeUnit.SECONDS));
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"producer completed within time ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                producingThread.join(1000L);
                return !producingThread.isAlive();
            }
        }));
        final DestinationViewMBean view = this.createView(this.destination);
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"all dispatched up to default prefetch ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 600L == view.getDispatchCount();
            }
        }));
        ExpiredMessagesWithNoConsumerTest.assertTrue((String)"All sent have expired ", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 1500L == view.getExpiredCount();
            }
        }));
        LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
        waitCondition.countDown();
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 299L == view.getInFlightCount();
            }
        });
        LOG.info((Object)("enqueue=" + view.getEnqueueCount() + ", dequeue=" + view.getDequeueCount() + ", inflight=" + view.getInFlightCount() + ", expired= " + view.getExpiredCount() + ", size= " + view.getQueueSize()));
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"inflight reduces to half prefetch minus single delivered message", (long)299L, (long)view.getInFlightCount());
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"size gets back to 0 ", (long)0L, (long)view.getQueueSize());
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"dequeues match sent/expired ", (long)1500L, (long)view.getDequeueCount());
        this.producer.setTimeToLive(0L);
        int i = 0;
        while ((long)i < 1500L) {
            this.producer.send((Message)this.session.createTextMessage("test-" + i));
            ++i;
        }
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return received.get() >= 1500L;
            }
        });
        consumer.close();
        Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 0L == view.getInFlightCount();
            }
        });
        ExpiredMessagesWithNoConsumerTest.assertEquals((String)"inflight goes to zeor on close", (long)0L, (long)view.getInFlightCount());
        LOG.info((Object)("done: " + this.getName()));
    }

    protected DestinationViewMBean createView(ActiveMQDestination destination) throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = destination.isQueue() ? new ObjectName(domain + ":BrokerName=localhost,Type=Queue,Destination=test") : new ObjectName(domain + ":BrokerName=localhost,Type=Topic,Destination=test");
        return (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }

    protected void tearDown() throws Exception {
        this.connection.stop();
        this.broker.stop();
        this.broker.waitUntilStopped();
    }
}

