/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class MessageReroutingTest
extends JmsMultipleBrokersTestSupport {
    private static final transient Log LOG = LogFactory.getLog(MessageReroutingTest.class);
    public Destination dest;
    public static final int MESSAGE_COUNT = 50;

    protected void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rerouting-activemq-D.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rerouting-activemq-C.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rerouting-activemq-B.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/rerouting-activemq-A.xml"));
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-A")).broker.waitUntilStarted();
    }

    public void initCombos() {
        this.addCombinationValues("dest", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST")});
    }

    public void testMessageRerouting() throws Exception {
        MessageConsumer consumer = this.createConsumer("broker-D", this.dest);
        MessageIdList received = this.getConsumerMessages("broker-D", consumer);
        Thread.sleep(2000L);
        this.sendMessages("broker-A", this.dest, 50);
        received.waitForMessagesToArrive(50);
        LOG.info((Object)("received " + received.getMessageCount() + " messages"));
        MessageReroutingTest.assertEquals((int)50, (int)received.getMessageCount());
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-B")).broker.stop();
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"broker-B")).broker.waitUntilStopped();
        Thread.sleep(2000L);
        this.sendMessages("broker-A", this.dest, 50);
        received.waitForMessagesToArrive(50);
        LOG.info((Object)("received " + received.getMessageCount() + " messages"));
        MessageReroutingTest.assertTrue((String)("Didn't receive any more messages " + received.getMessageCount()), (received.getMessageCount() > 50 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return MessageReroutingTest.suite(MessageReroutingTest.class);
    }
}

