/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class MyObject
implements Serializable {
    private String message;
    private AtomicInteger writeObjectCalled = new AtomicInteger(0);
    private AtomicInteger readObjectCalled = new AtomicInteger(0);
    private AtomicInteger readObjectNoDataCalled = new AtomicInteger(0);

    public MyObject(String message) {
        this.setMessage(message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObjectCalled.incrementAndGet();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readObjectCalled.incrementAndGet();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.readObjectNoDataCalled.incrementAndGet();
    }

    public int getWriteObjectCalled() {
        return this.writeObjectCalled.get();
    }

    public int getReadObjectCalled() {
        return this.readObjectCalled.get();
    }

    public int getReadObjectNoDataCalled() {
        return this.readObjectNoDataCalled.get();
    }
}

