/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueDuplicatesTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(QueueDuplicatesTest.class);
    private static DateFormat formatter = new SimpleDateFormat("HH:mm:ss SSS");
    private String brokerUrl;
    private String subject;
    private Connection brokerConnection;

    public QueueDuplicatesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        String peerUrl = "peer://localhost:6099";
        this.subject = ((Object)((Object)this)).getClass().getName();
        ActiveMQConnectionFactory fac = this.createFactory(peerUrl);
        this.brokerConnection = fac.createConnection();
        this.brokerConnection.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerConnection != null) {
            this.brokerConnection.close();
        }
    }

    public void testDuplicates() {
        try {
            Session session = this.createSession(this.brokerConnection);
            Queue dest = session.createQueue(this.subject);
            MessageConsumer consumer = session.createConsumer((Destination)dest);
            consumer.setMessageListener((MessageListener)new SimpleConsumer());
            SendingThread sendingThread = new SendingThread(this.brokerUrl, this.subject);
            sendingThread.start();
            Thread.sleep(5000L);
            consumer.close();
            Thread.sleep(5000L);
            consumer = session.createConsumer((Destination)dest);
            consumer.setMessageListener((MessageListener)new SimpleConsumer());
            Thread.sleep(15000L);
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Session createSession(Connection peerConnection) throws JMSException {
        Session session = peerConnection.createSession(false, 1);
        return session;
    }

    private ActiveMQConnectionFactory createFactory(String brokerUrl) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        cf.setBrokerURL(brokerUrl);
        return cf;
    }

    private static class SimpleConsumer
    implements MessageListener {
        private Map<String, Message> msgs = new HashMap<String, Message>();

        private SimpleConsumer() {
        }

        public void onMessage(Message message) {
            LOG.info((Object)(formatter.format(new Date()) + " SimpleConsumer Message Received: " + message));
            try {
                String id = message.getJMSMessageID();
                Assert.assertNull((String)("Message is duplicate: " + id), (Object)this.msgs.get(id));
                this.msgs.put(id, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SendingThread
    extends Thread {
        private String subject;

        SendingThread(String brokerUrl, String subject) {
            this.subject = subject;
            this.setDaemon(false);
        }

        public void run() {
            try {
                Session session = QueueDuplicatesTest.this.createSession(QueueDuplicatesTest.this.brokerConnection);
                Queue dest = session.createQueue(this.subject);
                MessageProducer producer = session.createProducer((Destination)dest);
                producer.setDeliveryMode(1);
                for (int i = 0; i < 20; ++i) {
                    String txt = "Text Message: " + i;
                    TextMessage msg = session.createTextMessage(txt);
                    producer.send((Message)msg);
                    LOG.info((Object)(formatter.format(new Date()) + " Sent ==> " + msg + " to " + this.subject));
                    Thread.sleep(1000L);
                }
                session.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

