/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.usage.SystemUsage;

public class QueueMemoryFullMultiBrokersTest
extends JmsMultipleBrokersTestSupport {
    public static final int BROKER_COUNT = 2;
    public static final int MESSAGE_COUNT = 2000;

    public void testQueueNetworkWithConsumerFull() throws Exception {
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("Broker1", (Destination)dest, 50);
        CountDownLatch latch = new CountDownLatch(2000);
        this.createConsumer("Broker2", (Destination)dest, latch);
        this.assertConsumersConnect("Broker1", (Destination)dest, 1, 30000L);
        this.sendMessages("Broker1", (Destination)dest, 1950);
        QueueMemoryFullMultiBrokersTest.assertTrue((String)("Missing " + latch.getCount() + " messages"), (boolean)latch.await(45L, TimeUnit.SECONDS));
        BrokerService broker1 = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker;
        RegionBroker regionBroker = (RegionBroker)broker1.getRegionBroker();
        Thread.sleep(2000L);
        Queue internalQueue = (Queue)regionBroker.getDestinations(ActiveMQDestination.transform((Destination)dest)).iterator().next();
        QueueMemoryFullMultiBrokersTest.assertTrue((String)("All messages are consumed and acked from source:" + internalQueue), (boolean)internalQueue.getMessages().isEmpty());
        QueueMemoryFullMultiBrokersTest.assertEquals((String)("messages source:" + internalQueue), (long)0L, (long)internalQueue.getDestinationStatistics().getMessages().getCount());
        QueueMemoryFullMultiBrokersTest.assertEquals((String)("inflight source:" + internalQueue), (long)0L, (long)internalQueue.getDestinationStatistics().getInflight().getCount());
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.messageSize = 1024;
        for (int i = 1; i <= 2; ++i) {
            this.createBroker(new URI("broker:()/Broker" + i + "?persistent=false&useJmx=false"));
        }
        BrokerService broker2 = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker2")).broker;
        this.applyMemoryLimitPolicy(broker2);
    }

    private void applyMemoryLimitPolicy(BrokerService broker) {
        SystemUsage memoryManager = new SystemUsage();
        memoryManager.getMemoryUsage().setLimit(51200L);
        broker.setSystemUsage(memoryManager);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit(4096L);
        entry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        broker.setDestinationPolicy(policyMap);
    }
}

