/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.Before;
import org.junit.Test;

public class UnlimitedEnqueueTest {
    BrokerService brokerService = null;
    final long numMessages = 50000L;
    final long numThreads = 10L;

    @Test
    public void testEnqueueIsOnlyLimitedByDisk() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        int i = 0;
        while ((long)i < 10L) {
            executor.execute(new Producer(5000L));
            ++i;
        }
        executor.shutdown();
        executor.awaitTermination(1800L, TimeUnit.SECONDS);
    }

    @Before
    public void createBrokerService() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(0xA00000L);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry policy = new PolicyEntry();
        policy.setCursorMemoryHighWaterMark(20);
        policy.setQueue(">");
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new FilePendingQueueMessageStoragePolicy());
        entries.add(policy);
        policyMap.setPolicyEntries(entries);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.start();
    }

    public class Producer
    implements Runnable {
        private final long numberOfMessages;

        public Producer(long n) {
            this.numberOfMessages = n;
        }

        public void run() {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(UnlimitedEnqueueTest.this.brokerService.getVmConnectorURI());
            try {
                Connection conn = factory.createConnection();
                conn.start();
                int i = 0;
                while ((long)i < this.numberOfMessages) {
                    Session session = conn.createSession(false, 1);
                    Queue destination = session.createQueue("test-queue");
                    MessageProducer producer = session.createProducer((Destination)destination);
                    producer.setDeliveryMode(2);
                    BytesMessage message = session.createBytesMessage();
                    byte[] bytes = new byte[10240];
                    message.writeBytes(bytes);
                    try {
                        producer.send((Message)message);
                    }
                    catch (ResourceAllocationException e) {
                        e.printStackTrace();
                    }
                    session.close();
                    ++i;
                }
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

