/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.Hashtable;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.JMXSupport;

public class ManagementContextXBeanConfigTest
extends TestCase {
    protected BrokerService brokerService;

    public void testManagmentContextConfiguredCorrectly() throws Exception {
        ManagementContextXBeanConfigTest.assertEquals((int)2011, (int)this.brokerService.getManagementContext().getConnectorPort());
        ManagementContextXBeanConfigTest.assertEquals((String)"test.domain", (String)this.brokerService.getManagementContext().getJmxDomainName());
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("Type", "Broker");
        map.put("BrokerName", JMXSupport.encodeObjectNamePart((String)"localhost"));
        ObjectName on = new ObjectName("test.domain", map);
        Object value = this.brokerService.getManagementContext().getAttribute(on, "TotalEnqueueCount");
        ManagementContextXBeanConfigTest.assertNotNull((Object)value);
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/management-context-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

