/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.requestor.DeferredRequestReplyMap;
import org.apache.camel.component.jms.requestor.PersistentReplyToRequestor;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.UuidGenerator;
import org.apache.camel.util.ValueHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class JmsProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(JmsProducer.class);
    private RequestorAffinity affinity;
    private final JmsEndpoint endpoint;
    private JmsOperations inOnlyTemplate;
    private JmsOperations inOutTemplate;
    private UuidGenerator uuidGenerator;
    private DeferredRequestReplyMap deferredRequestReplyMap;
    private Requestor requestor;
    private AtomicBoolean started = new AtomicBoolean(false);

    public JmsProducer(JmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        JmsConfiguration c = endpoint.getConfiguration();
        this.affinity = RequestorAffinity.PER_PRODUCER;
        if (c.getReplyTo() != null) {
            if (c.getReplyToTempDestinationAffinity().equals("endpoint")) {
                this.affinity = RequestorAffinity.PER_ENDPOINT;
            } else if (c.getReplyToTempDestinationAffinity().equals("component")) {
                this.affinity = RequestorAffinity.PER_COMPONENT;
            }
        }
    }

    public long getRequestTimeout() {
        return this.endpoint.getConfiguration().getRequestTimeout();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAndSetRequestor() throws RuntimeCamelException {
        if (!this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (this.started.get()) {
                    return;
                }
                try {
                    JmsConfiguration c = this.endpoint.getConfiguration();
                    if (c.getReplyTo() != null) {
                        this.requestor = new PersistentReplyToRequestor(this.endpoint.getConfiguration(), this.endpoint.getScheduledExecutorService());
                        this.requestor.start();
                    } else if (this.affinity == RequestorAffinity.PER_PRODUCER) {
                        this.requestor = new Requestor(this.endpoint.getConfiguration(), this.endpoint.getScheduledExecutorService());
                        this.requestor.start();
                    } else if (this.affinity == RequestorAffinity.PER_ENDPOINT) {
                        this.requestor = this.endpoint.getRequestor();
                    } else if (this.affinity == RequestorAffinity.PER_COMPONENT) {
                        this.requestor = ((JmsComponent)this.endpoint.getComponent()).getRequestor();
                    }
                }
                catch (Exception e) {
                    throw new FailedToCreateProducerException((Endpoint)this.endpoint, (Throwable)e);
                }
                this.deferredRequestReplyMap = this.requestor.getDeferredRequestReplyMap(this);
                this.started.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAndUnsetRequestor() throws Exception {
        if (this.started.get()) {
            JmsProducer jmsProducer = this;
            synchronized (jmsProducer) {
                if (!this.started.get()) {
                    return;
                }
                this.requestor.removeDeferredRequestReplyMap(this);
                if (this.affinity == RequestorAffinity.PER_PRODUCER) {
                    this.requestor.stop();
                }
                this.started.set(false);
            }
        }
    }

    protected void doStop() throws Exception {
        this.testAndUnsetRequestor();
        super.doStop();
    }

    public void process(Exchange exchange) {
        if (!this.endpoint.isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
            this.processInOut(exchange);
        } else {
            this.processInOnly(exchange);
        }
    }

    protected void processInOut(final Exchange exchange) {
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        in.removeHeader("CamelJmsDestinationName");
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        Destination destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class);
        in.removeHeader("CamelJmsDestination");
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        this.testAndSetRequestor();
        final Destination replyTo = this.requestor.getReplyTo();
        if (replyTo == null) {
            throw new RuntimeExchangeException("Failed to resolve replyTo destination", exchange);
        }
        final boolean msgIdAsCorrId = this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID();
        String correlationId = (String)in.getHeader("JMSCorrelationID", String.class);
        if (correlationId == null && !msgIdAsCorrId) {
            in.setHeader("JMSCorrelationID", (Object)this.getUuidGenerator().generateUuid());
        }
        final ValueHolder futureHolder = new ValueHolder();
        final DeferredRequestReplyMap.DeferredMessageSentCallback callback = msgIdAsCorrId ? this.deferredRequestReplyMap.createDeferredMessageSentCallback() : null;
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
                message.setJMSReplyTo(replyTo);
                JmsProducer.this.requestor.setReplyToSelectorHeader(in, message);
                FutureTask future = !msgIdAsCorrId ? JmsProducer.this.requestor.getReceiveFuture(message.getJMSCorrelationID(), JmsProducer.this.endpoint.getConfiguration().getRequestTimeout()) : JmsProducer.this.requestor.getReceiveFuture(callback);
                futureHolder.set((Object)future);
                return message;
            }
        };
        this.doSend(true, destinationName, destination, messageCreator, callback);
        this.setMessageId(exchange);
        long requestTimeout = this.endpoint.getConfiguration().getRequestTimeout();
        try {
            javax.jms.Message message;
            block19: {
                message = null;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Message sent, now waiting for reply at: " + replyTo.toString()));
                    }
                    message = requestTimeout <= 0L ? (javax.jms.Message)((FutureTask)futureHolder.get()).get() : (javax.jms.Message)((FutureTask)futureHolder.get()).get(requestTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Future interrupted: " + e), (Throwable)e);
                    }
                }
                catch (TimeoutException e) {
                    if (!LOG.isDebugEnabled()) break block19;
                    LOG.debug((Object)("Future timed out: " + e), (Throwable)e);
                }
            }
            if (message != null) {
                JmsMessage response = new JmsMessage(message, this.endpoint.getBinding());
                Object body = response.getBody();
                if (this.endpoint.isTransferException() && body instanceof Exception) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Reply received. Setting reply as an Exception: " + body));
                    }
                    exchange.setException((Throwable)((Exception)body));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Reply received. Setting reply as OUT message: " + body));
                    }
                    exchange.setOut((Message)response);
                }
                if (correlationId != null) {
                    message.setJMSCorrelationID(correlationId);
                    exchange.getOut().setHeader("JMSCorrelationID", (Object)correlationId);
                }
            } else {
                exchange.setException((Throwable)new ExchangeTimedOutException(exchange, requestTimeout));
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    protected void processInOnly(final Exchange exchange) {
        Object replyTo;
        Destination destination;
        final Message in = exchange.getIn();
        String destinationName = (String)in.getHeader("CamelJmsDestinationName", String.class);
        if (destinationName != null) {
            in.removeHeader("CamelJmsDestinationName");
        }
        if (destinationName == null) {
            destinationName = this.endpoint.getDestinationName();
        }
        if ((destination = (Destination)in.getHeader("CamelJmsDestination", Destination.class)) != null) {
            in.removeHeader("CamelJmsDestination");
        }
        if (destination == null) {
            destination = this.endpoint.getDestination();
        }
        if (destination != null) {
            destinationName = null;
        }
        if (!this.endpoint.isPreserveMessageQos() && !this.endpoint.isExplicitQosEnabled() && (replyTo = exchange.getIn().getHeader("JMSReplyTo")) != null) {
            String to = destinationName != null ? destinationName : "" + destination;
            LOG.warn((Object)("Disabling JMSReplyTo as this Exchange is not OUT capable with JMSReplyTo: " + replyTo + " for destination: " + to + ". Use preserveMessageQos=true to force Camel to keep the JMSReplyTo." + " Exchange: " + exchange));
            exchange.getIn().setHeader("JMSReplyTo", null);
        }
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                return JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session, null);
            }
        };
        this.doSend(false, destinationName, destination, messageCreator, null);
        this.setMessageId(exchange);
    }

    protected void doSend(boolean inOut, String destinationName, Destination destination, MessageCreator messageCreator, DeferredRequestReplyMap.DeferredMessageSentCallback callback) {
        JmsConfiguration.CamelJmsTemplate template = null;
        JmsConfiguration.CamelJmsTemplate102 template102 = null;
        if (this.endpoint.isUseVersion102()) {
            template102 = (JmsConfiguration.CamelJmsTemplate102)(inOut ? this.getInOutTemplate() : this.getInOnlyTemplate());
        } else {
            template = (JmsConfiguration.CamelJmsTemplate)(inOut ? this.getInOutTemplate() : this.getInOnlyTemplate());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using " + (inOut ? "inOut" : "inOnly") + " jms template to send with API " + (this.endpoint.isUseVersion102() ? "v1.0.2" : "v1.1")));
        }
        if (destination != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destination, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                } else if (template102 != null) {
                    template102.send(destination, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                }
            } else if (template != null) {
                template.send(destination, messageCreator);
            } else if (template102 != null) {
                template102.send(destination, messageCreator);
            }
        } else if (destinationName != null) {
            if (inOut) {
                if (template != null) {
                    template.send(destinationName, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                } else if (template102 != null) {
                    template102.send(destinationName, messageCreator, (JmsConfiguration.MessageSentCallback)callback);
                }
            } else if (template != null) {
                template.send(destinationName, messageCreator);
            } else if (template102 != null) {
                template102.send(destinationName, messageCreator);
            }
        } else {
            throw new IllegalArgumentException("Neither destination nor destinationName is specified on this endpoint: " + (Object)((Object)this.endpoint));
        }
    }

    protected void setMessageId(Exchange exchange) {
        if (exchange.hasOut()) {
            JmsMessage out = (JmsMessage)exchange.getOut();
            try {
                if (out != null && out.getJmsMessage() != null) {
                    out.setMessageId(out.getJmsMessage().getJMSMessageID());
                }
            }
            catch (JMSException e) {
                LOG.warn((Object)"Unable to retrieve JMSMessageID from outgoing JMS Message and set it into Camel's MessageId", (Throwable)e);
            }
        }
    }

    public JmsOperations getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(JmsOperations inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public JmsOperations getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(JmsOperations inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            this.uuidGenerator = UuidGenerator.get();
        }
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestorAffinity {
        PER_COMPONENT(0),
        PER_ENDPOINT(1),
        PER_PRODUCER(2);

        private int value;

        private RequestorAffinity(int value) {
            this.value = value;
        }
    }
}

