/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.Service;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.MessageVariableResolver;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathBuilder
implements Expression,
Predicate,
NamespaceAware,
Service {
    private static final transient Log LOG = LogFactory.getLog(XPathBuilder.class);
    private final Queue<XPathExpression> pool = new ConcurrentLinkedQueue<XPathExpression>();
    private final String text;
    private final ThreadLocal<MessageVariableResolver> variableResolver = new ThreadLocal();
    private final ThreadLocal<Exchange> exchange = new ThreadLocal();
    private XPathFactory xpathFactory;
    private Class<?> documentType = Document.class;
    private Class<?> resultType;
    private QName resultQName = XPathConstants.NODESET;
    private String objectModelUri;
    private DefaultNamespaceContext namespaceContext;
    private XPathFunctionResolver functionResolver;
    private XPathFunction bodyFunction;
    private XPathFunction headerFunction;
    private XPathFunction outBodyFunction;
    private XPathFunction outHeaderFunction;
    private XPathFunction propertiesFunction;
    private XPathFunction simpleFunction;

    public XPathBuilder(String text) {
        this.text = text;
    }

    public static XPathBuilder xpath(String text) {
        return new XPathBuilder(text);
    }

    public static XPathBuilder xpath(String text, Class<?> resultType) {
        XPathBuilder builder = new XPathBuilder(text);
        builder.setResultType(resultType);
        return builder;
    }

    public String toString() {
        return "XPath: " + this.text;
    }

    @Override
    public boolean matches(Exchange exchange) {
        exchange.addOnCompletion(new XPathBuilderOnCompletion());
        Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
        return exchange.getContext().getTypeConverter().convertTo(Boolean.class, booleanResult);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        exchange.addOnCompletion(new XPathBuilderOnCompletion());
        Object result = this.evaluate(exchange);
        return exchange.getContext().getTypeConverter().convertTo(type, result);
    }

    public boolean matches(CamelContext context, Object body) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        boolean answer = this.matches(dummy);
        this.variableResolver.remove();
        this.exchange.remove();
        return answer;
    }

    public <T> T evaluate(CamelContext context, Object body, Class<T> type) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        T answer = this.evaluate(dummy, type);
        this.variableResolver.remove();
        this.exchange.remove();
        return answer;
    }

    public String evaluate(CamelContext context, Object body) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        this.setResultQName(XPathConstants.STRING);
        String answer = this.evaluate(dummy, String.class);
        this.variableResolver.remove();
        this.exchange.remove();
        return answer;
    }

    public XPathBuilder booleanResult() {
        this.resultQName = XPathConstants.BOOLEAN;
        return this;
    }

    public XPathBuilder nodeResult() {
        this.resultQName = XPathConstants.NODE;
        return this;
    }

    public XPathBuilder nodeSetResult() {
        this.resultQName = XPathConstants.NODESET;
        return this;
    }

    public XPathBuilder numberResult() {
        this.resultQName = XPathConstants.NUMBER;
        return this;
    }

    public XPathBuilder stringResult() {
        this.resultQName = XPathConstants.STRING;
        return this;
    }

    public XPathBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public XPathBuilder objectModel(String uri) {
        this.objectModelUri = uri;
        return this;
    }

    public XPathBuilder saxon() {
        this.objectModelUri = "http://saxon.sf.net/jaxp/xpath/om";
        return this;
    }

    public XPathBuilder functionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
        return this;
    }

    public XPathBuilder namespace(String prefix, String uri) {
        this.getNamespaceContext().add(prefix, uri);
        return this;
    }

    public XPathBuilder namespaces(Namespaces namespaces) {
        namespaces.configure(this);
        return this;
    }

    public XPathBuilder variable(String name, Object value) {
        this.getVariableResolver().addVariable(name, value);
        return this;
    }

    public XPathBuilder documentType(Class<?> documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    public XPathBuilder factory(XPathFactory xpathFactory) {
        this.setXPathFactory(xpathFactory);
        return this;
    }

    public XPathFactory getXPathFactory() throws XPathFactoryConfigurationException {
        if (this.xpathFactory == null) {
            if (this.objectModelUri != null) {
                LOG.info((Object)("Using objectModelUri " + this.objectModelUri + " when creating XPathFactory"));
                this.xpathFactory = XPathFactory.newInstance(this.objectModelUri);
                return this.xpathFactory;
            }
            Properties properties = System.getProperties();
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                String uri;
                String key = (String)prop.getKey();
                if (!key.startsWith("javax.xml.xpath.XPathFactory") || (uri = ObjectHelper.after(key, ":")) == null) continue;
                LOG.info((Object)("Using system property " + key + " with value: " + prop.getValue() + " when creating XPathFactory"));
                this.xpathFactory = XPathFactory.newInstance(uri);
                return this.xpathFactory;
            }
            if (this.xpathFactory == null) {
                LOG.debug((Object)"Creating default XPathFactory");
                this.xpathFactory = XPathFactory.newInstance();
            }
        }
        return this.xpathFactory;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public Class<?> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class<?> documentType) {
        this.documentType = documentType;
    }

    public String getText() {
        return this.text;
    }

    public QName getResultQName() {
        return this.resultQName;
    }

    public void setResultQName(QName resultQName) {
        this.resultQName = resultQName;
    }

    public DefaultNamespaceContext getNamespaceContext() {
        if (this.namespaceContext == null) {
            try {
                DefaultNamespaceContext defaultNamespaceContext = new DefaultNamespaceContext(this.getXPathFactory());
                this.populateDefaultNamespaces(defaultNamespaceContext);
                this.namespaceContext = defaultNamespaceContext;
            }
            catch (XPathFactoryConfigurationException e) {
                throw new RuntimeExpressionException(e);
            }
        }
        return this.namespaceContext;
    }

    public void setNamespaceContext(DefaultNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.getNamespaceContext().setNamespaces(namespaces);
    }

    public XPathFunction getBodyFunction() {
        if (this.bodyFunction == null) {
            this.bodyFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    if (XPathBuilder.this.exchange == null) {
                        return null;
                    }
                    return ((Exchange)XPathBuilder.this.exchange.get()).getIn().getBody();
                }
            };
        }
        return this.bodyFunction;
    }

    public void setBodyFunction(XPathFunction bodyFunction) {
        this.bodyFunction = bodyFunction;
    }

    public XPathFunction getHeaderFunction() {
        if (this.headerFunction == null) {
            this.headerFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                        return ((Exchange)XPathBuilder.this.exchange.get()).getIn().getHeader(text);
                    }
                    return null;
                }
            };
        }
        return this.headerFunction;
    }

    public void setHeaderFunction(XPathFunction headerFunction) {
        this.headerFunction = headerFunction;
    }

    public XPathFunction getOutBodyFunction() {
        if (this.outBodyFunction == null) {
            this.outBodyFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    if (XPathBuilder.this.exchange.get() != null && ((Exchange)XPathBuilder.this.exchange.get()).hasOut()) {
                        return ((Exchange)XPathBuilder.this.exchange.get()).getOut().getBody();
                    }
                    return null;
                }
            };
        }
        return this.outBodyFunction;
    }

    public void setOutBodyFunction(XPathFunction outBodyFunction) {
        this.outBodyFunction = outBodyFunction;
    }

    public XPathFunction getOutHeaderFunction() {
        if (this.outHeaderFunction == null) {
            this.outHeaderFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange.get() != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                        return ((Exchange)XPathBuilder.this.exchange.get()).getOut().getHeader(text);
                    }
                    return null;
                }
            };
        }
        return this.outHeaderFunction;
    }

    public void setOutHeaderFunction(XPathFunction outHeaderFunction) {
        this.outHeaderFunction = outHeaderFunction;
    }

    public XPathFunction getPropertiesFunction() {
        if (this.propertiesFunction == null) {
            this.propertiesFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                        try {
                            String answer = ((Exchange)XPathBuilder.this.exchange.get()).getContext().resolvePropertyPlaceholders("{{" + text + "}}");
                            return answer;
                        }
                        catch (Exception e) {
                            throw new XPathFunctionException(e);
                        }
                    }
                    return null;
                }
            };
        }
        return this.propertiesFunction;
    }

    public void setPropertiesFunction(XPathFunction propertiesFunction) {
        this.propertiesFunction = propertiesFunction;
    }

    public XPathFunction getSimpleFunction() {
        if (this.simpleFunction == null) {
            this.simpleFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                        Language simple = ((Exchange)XPathBuilder.this.exchange.get()).getContext().resolveLanguage("simple");
                        Expression exp = simple.createExpression(text);
                        Object answer = exp.evaluate((Exchange)XPathBuilder.this.exchange.get(), Object.class);
                        return answer;
                    }
                    return null;
                }
            };
        }
        return this.simpleFunction;
    }

    public void setSimpleFunction(XPathFunction simpleFunction) {
        this.simpleFunction = simpleFunction;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
        if (Number.class.isAssignableFrom(resultType)) {
            this.numberResult();
        } else if (String.class.isAssignableFrom(resultType)) {
            this.stringResult();
        } else if (Boolean.class.isAssignableFrom(resultType)) {
            this.booleanResult();
        } else if (Node.class.isAssignableFrom(resultType)) {
            this.nodeResult();
        } else if (NodeList.class.isAssignableFrom(resultType)) {
            this.nodeSetResult();
        }
    }

    protected Object evaluate(Exchange exchange) {
        Object answer = this.evaluateAs(exchange, this.resultQName);
        if (this.resultType != null) {
            return ExchangeHelper.convertToType(exchange, this.resultType, answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateAs(Exchange exchange, QName resultQName) {
        Object object;
        XPathExpression xpathExpression = this.pool.poll();
        if (xpathExpression == null) {
            LOG.trace((Object)"Creating new XPathExpression as none was available from pool");
            try {
                xpathExpression = this.createXPathExpression();
            }
            catch (XPathExpressionException e) {
                throw new InvalidXPathExpression(this.getText(), e);
            }
            catch (Exception e) {
                throw new RuntimeExpressionException("Cannot create xpath expression", e);
            }
        } else {
            LOG.trace((Object)"Acquired XPathExpression from pool");
        }
        try {
            object = this.doInEvaluateAs(xpathExpression, exchange, resultQName);
            Object var6_7 = null;
            this.pool.add(xpathExpression);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.pool.add(xpathExpression);
            LOG.trace((Object)"Released XPathExpression back to pool");
            throw throwable;
        }
        LOG.trace((Object)"Released XPathExpression back to pool");
        return object;
    }

    protected Object doInEvaluateAs(XPathExpression xpathExpression, Exchange exchange, QName resultQName) {
        Object answer;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Evaluating exchange: " + exchange + " as: " + resultQName));
        }
        this.exchange.set(exchange);
        try {
            Object document = this.getDocument(exchange);
            if (resultQName != null) {
                if (document instanceof InputSource) {
                    InputSource inputSource = (InputSource)document;
                    answer = xpathExpression.evaluate(inputSource, resultQName);
                } else if (document instanceof DOMSource) {
                    DOMSource source = (DOMSource)document;
                    answer = xpathExpression.evaluate(source.getNode(), resultQName);
                } else {
                    answer = xpathExpression.evaluate(document, resultQName);
                }
            } else if (document instanceof InputSource) {
                InputSource inputSource = (InputSource)document;
                answer = xpathExpression.evaluate(inputSource);
            } else if (document instanceof DOMSource) {
                DOMSource source = (DOMSource)document;
                answer = xpathExpression.evaluate(source.getNode());
            } else {
                answer = xpathExpression.evaluate(document);
            }
        }
        catch (XPathExpressionException e) {
            throw new InvalidXPathExpression(this.getText(), e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Done evaluating exchange: " + exchange + " as: " + resultQName + " with result: " + answer));
        }
        return answer;
    }

    protected XPathExpression createXPathExpression() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.getXPathFactory().newXPath();
        xPath.setNamespaceContext(this.getNamespaceContext());
        xPath.setXPathVariableResolver(this.getVariableResolver());
        XPathFunctionResolver parentResolver = this.getFunctionResolver();
        if (parentResolver == null) {
            parentResolver = xPath.getXPathFunctionResolver();
        }
        xPath.setXPathFunctionResolver(this.createDefaultFunctionResolver(parentResolver));
        return xPath.compile(this.text);
    }

    protected void populateDefaultNamespaces(DefaultNamespaceContext context) {
        this.setNamespaceIfNotPresent(context, "in", "http://camel.apache.org/xml/in/");
        this.setNamespaceIfNotPresent(context, "out", "http://camel.apache.org/xml/out/");
        this.setNamespaceIfNotPresent(context, "env", "http://camel.apache.org/xml/variables/environment-variables");
        this.setNamespaceIfNotPresent(context, "system", "http://camel.apache.org/xml/variables/system-properties");
        this.setNamespaceIfNotPresent(context, "function", "http://camel.apache.org/xml/function/");
    }

    protected void setNamespaceIfNotPresent(DefaultNamespaceContext context, String prefix, String uri) {
        String current;
        if (context != null && (current = context.getNamespaceURI(prefix)) == null) {
            context.add(prefix, uri);
        }
    }

    protected XPathFunctionResolver createDefaultFunctionResolver(final XPathFunctionResolver parent) {
        return new XPathFunctionResolver(){

            public XPathFunction resolveFunction(QName qName, int argumentCount) {
                XPathFunction answer = null;
                if (parent != null) {
                    answer = parent.resolveFunction(qName, argumentCount);
                }
                if (answer == null) {
                    String localPart;
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/in/") || Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/schema/spring")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getHeaderFunction();
                        }
                    }
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/out/")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getOutBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getOutHeaderFunction();
                        }
                    }
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/function/")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("properties") && argumentCount == 1) {
                            return XPathBuilder.this.getPropertiesFunction();
                        }
                        if (localPart.equals("simple") && argumentCount == 1) {
                            return XPathBuilder.this.getSimpleFunction();
                        }
                    }
                }
                return answer;
            }
        };
    }

    protected Object getDocument(Exchange exchange) {
        Object answer = null;
        Message in = exchange.getIn();
        Class<?> type = this.getDocumentType();
        if (type != null) {
            answer = in.getBody(type);
        }
        if (answer == null) {
            answer = in.getBody();
        }
        if (answer instanceof GenericFile) {
            InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, answer);
            answer = new InputSource(is);
        } else if (answer instanceof BeanInvocation) {
            BeanInvocation bi = exchange.getContext().getTypeConverter().convertTo(BeanInvocation.class, answer);
            if (bi.getArgs() != null && bi.getArgs().length == 1 && bi.getArgs()[0] == null) {
                answer = null;
            }
        } else if (answer instanceof String) {
            answer = new InputSource(new StringReader(answer.toString()));
        }
        MessageHelper.resetStreamCache(exchange.getIn());
        return answer;
    }

    private MessageVariableResolver getVariableResolver() {
        MessageVariableResolver resolver = this.variableResolver.get();
        if (resolver == null) {
            resolver = new MessageVariableResolver(this.exchange);
            this.variableResolver.set(resolver);
        }
        return resolver;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.pool.clear();
    }

    private final class XPathBuilderOnCompletion
    extends SynchronizationAdapter {
        private XPathBuilderOnCompletion() {
        }

        public void onDone(Exchange exchange) {
            if (exchange.equals(XPathBuilder.this.exchange.get())) {
                XPathBuilder.this.variableResolver.remove();
                XPathBuilder.this.exchange.remove();
            }
        }

        public boolean allowHandover() {
            return false;
        }

        public String toString() {
            return "XPathBuilderOnCompletion";
        }
    }
}

