/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.TimeClause;
import org.apache.camel.util.PredicateAssertHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssertionClause
extends ExpressionClauseSupport<ValueBuilder>
implements Runnable {
    protected final MockEndpoint mock;
    protected volatile int currentIndex;
    private final List<Predicate> predicates = new ArrayList<Predicate>();
    private final Expression previous = new PreviousTimestamp();
    private final Expression next = new NextTimestamp();

    public AssertionClause(MockEndpoint mock) {
        super(null);
        this.mock = mock;
    }

    @Override
    public ValueBuilder expression(Expression expression) {
        super.expression(expression);
        return new PredicateValueBuilder(this.getExpressionValue());
    }

    public AssertionClause predicate(Predicate predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public ExpressionClause<AssertionClause> predicate() {
        ExpressionClause<AssertionClause> clause = new ExpressionClause<AssertionClause>(this);
        this.addPredicate(clause);
        return clause;
    }

    public TimeClause arrives() {
        final TimeClause clause = new TimeClause(this.previous, this.next);
        this.addPredicate(new Predicate(){

            public boolean matches(Exchange exchange) {
                return clause.matches(exchange);
            }

            public String toString() {
                return "arrives " + clause.toString() + " exchange";
            }
        });
        return clause;
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, Exchange exchange) {
        for (Predicate predicate : this.predicates) {
            this.currentIndex = index;
            PredicateAssertHelper.assertMatches(predicate, "Assertion error at index " + index + " on mock " + endpoint.getEndpointUri() + " with predicate: ", exchange);
        }
    }

    protected void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    public final class PredicateValueBuilder
    extends ValueBuilder {
        public PredicateValueBuilder(Expression expression) {
            super(expression);
        }

        protected Predicate onNewPredicate(Predicate predicate) {
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NextTimestamp
    implements Expression {
        private NextTimestamp() {
        }

        @Override
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Date answer = null;
            if (AssertionClause.this.currentIndex < AssertionClause.this.mock.getReceivedCounter() - 1) {
                answer = AssertionClause.this.mock.getReceivedExchanges().get(AssertionClause.this.currentIndex + 1).getProperty("CamelReceivedTimestamp", Date.class);
            }
            return (T)answer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PreviousTimestamp
    implements Expression {
        private PreviousTimestamp() {
        }

        @Override
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Date answer = null;
            if (AssertionClause.this.currentIndex > 0 && AssertionClause.this.mock.getReceivedCounter() > 0) {
                answer = AssertionClause.this.mock.getReceivedExchanges().get(AssertionClause.this.currentIndex - 1).getProperty("CamelReceivedTimestamp", Date.class);
            }
            return (T)answer;
        }
    }
}

