/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.SuspendableService;
import org.apache.camel.TypeConverter;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultDataFormatResolver;
import org.apache.camel.impl.DefaultExecutorServiceStrategy;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultInflightRepository;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultNodeIdFactory;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.DefaultRouteStartupOrder;
import org.apache.camel.impl.DefaultShutdownStrategy;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.impl.EndpointRegistry;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.impl.RouteService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SharedProducerServicePool;
import org.apache.camel.impl.WebSpherePackageScanClassResolver;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.LazyLoadingTypeConverter;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.processor.interceptor.Debug;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCamelContext
extends ServiceSupport
implements CamelContext,
SuspendableService {
    private final transient Log log = LogFactory.getLog(this.getClass());
    private JAXBContext jaxbContext;
    private CamelContextNameStrategy nameStrategy = new DefaultCamelContextNameStrategy();
    private String managementName;
    private ClassLoader applicationContextClassLoader;
    private final Map<EndpointKey, Endpoint> endpoints = new EndpointRegistry();
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private Set<Route> routes;
    private final List<Service> servicesToClose = new ArrayList<Service>();
    private final Set<StartupListener> startupListeners = new LinkedHashSet<StartupListener>();
    private TypeConverter typeConverter;
    private TypeConverterRegistry typeConverterRegistry;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private Registry registry;
    private List<LifecycleStrategy> lifecycleStrategies = new ArrayList<LifecycleStrategy>();
    private ManagementStrategy managementStrategy;
    private AtomicBoolean managementStrategyInitialized = new AtomicBoolean(false);
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private volatile boolean firstStartDone;
    private volatile boolean doNotStartRoutesOnFirstStart;
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean trace = Boolean.FALSE;
    private Boolean streamCache = Boolean.FALSE;
    private Boolean handleFault = Boolean.FALSE;
    private Boolean disableJMX = Boolean.FALSE;
    private Boolean lazyLoadTypeConverters = Boolean.FALSE;
    private Long delay;
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private DataFormatResolver dataFormatResolver = new DefaultDataFormatResolver();
    private Map<String, String> properties = new HashMap<String, String>();
    private FactoryFinderResolver factoryFinderResolver = new DefaultFactoryFinderResolver();
    private FactoryFinder defaultFactoryFinder;
    private final Map<String, FactoryFinder> factories = new HashMap<String, FactoryFinder>();
    private final Map<String, RouteService> routeServices = new LinkedHashMap<String, RouteService>();
    private final Map<String, RouteService> suspendedRouteServices = new LinkedHashMap<String, RouteService>();
    private ClassResolver classResolver = new DefaultClassResolver();
    private PackageScanClassResolver packageScanClassResolver;
    private ServicePool<Endpoint, Producer> producerServicePool = new SharedProducerServicePool(100);
    private NodeIdFactory nodeIdFactory = new DefaultNodeIdFactory();
    private ProcessorFactory processorFactory;
    private InterceptStrategy defaultTracer;
    private InflightRepository inflightRepository = new DefaultInflightRepository();
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private int defaultRouteStartupOrder = 1000;
    private ShutdownStrategy shutdownStrategy = new DefaultShutdownStrategy(this);
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;
    private ExecutorServiceStrategy executorServiceStrategy = new DefaultExecutorServiceStrategy(this);
    private Debugger debugger;
    private UuidGenerator uuidGenerator = DefaultCamelContext.createDefaultUuidGenerator();
    private final StopWatch stopWatch = new StopWatch(false);
    private Date startDate;

    public DefaultCamelContext() {
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            this.log.info((Object)"Using WebSphere specific PackageScanClassResolver");
            this.packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            this.packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
    }

    public DefaultCamelContext(Context jndiContext) {
        this();
        this.setJndiContext(jndiContext);
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    @Override
    public String getName() {
        return this.getNameStrategy().getName();
    }

    public void setName(String name) {
        this.nameStrategy = new ExplicitCamelContextNameStrategy(name);
    }

    @Override
    public CamelContextNameStrategy getNameStrategy() {
        return this.nameStrategy;
    }

    @Override
    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    @Override
    public String getManagementName() {
        return this.managementName;
    }

    @Override
    public void setManagementName(String managementName) {
        this.managementName = managementName;
    }

    @Override
    public Component hasComponent(String componentName) {
        return this.components.get(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull(component, "component");
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentAdd(componentName, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && this.autoCreateComponents) {
                try {
                    component = this.getComponentResolver().resolveComponent(name, this);
                    if (component != null) {
                        this.addComponent(name, component);
                        if (this.isStarted() || this.isStarting()) {
                            this.startServices(component);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Cannot auto create component: " + name, e);
                }
            }
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        throw new IllegalArgumentException("Found component of type: " + component.getClass() + " instead of expected: " + componentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component answer = this.components.remove(componentName);
            if (answer != null) {
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onComponentRemove(componentName, answer);
                }
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints() {
        Map<EndpointKey, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<Endpoint>(this.endpoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Endpoint> getEndpointMap() {
        Map<EndpointKey, Endpoint> map = this.endpoints;
        synchronized (map) {
            TreeMap<String, Endpoint> answer = new TreeMap<String, Endpoint>();
            for (Map.Entry<EndpointKey, Endpoint> entry : this.endpoints.entrySet()) {
                answer.put((String)entry.getKey().get(), entry.getValue());
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint hasEndpoint(String uri) {
        Map<EndpointKey, Endpoint> map = this.endpoints;
        synchronized (map) {
            return this.endpoints.get(this.getEndpointKey(uri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        Endpoint oldEndpoint;
        Map<EndpointKey, Endpoint> map = this.endpoints;
        synchronized (map) {
            this.startServices(endpoint);
            oldEndpoint = this.endpoints.remove(this.getEndpointKey(uri));
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointAdd(endpoint);
            }
            this.addEndpointToRegistry(uri, endpoint);
            if (oldEndpoint != null) {
                this.stopServices(oldEndpoint);
            }
        }
        return oldEndpoint;
    }

    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Endpoint oldEndpoint = this.endpoints.remove(this.getEndpointKey(uri));
        if (oldEndpoint != null) {
            answer.add(oldEndpoint);
            this.stopServices(oldEndpoint);
        } else {
            for (Map.Entry<EndpointKey, Endpoint> entry : this.endpoints.entrySet()) {
                oldEndpoint = entry.getValue();
                if (!EndpointHelper.matchEndpoint(oldEndpoint.getEndpointUri(), uri)) continue;
                answer.add(oldEndpoint);
                this.stopServices(oldEndpoint);
            }
            for (Endpoint endpoint : answer) {
                this.endpoints.remove(this.getEndpointKey(endpoint.getEndpointUri()));
            }
        }
        for (Endpoint endpoint : answer) {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(endpoint);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getEndpoint(String uri) {
        Endpoint answer;
        ObjectHelper.notEmpty(uri, "uri");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting endpoint with uri: " + uri));
        }
        try {
            uri = this.resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        uri = DefaultCamelContext.normalizeEndpointUri(uri);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting endpoint with normalized uri: " + uri));
        }
        String scheme = null;
        Map<EndpointKey, Endpoint> map = this.endpoints;
        synchronized (map) {
            answer = this.endpoints.get(this.getEndpointKey(uri));
            if (answer == null) {
                try {
                    Component component;
                    String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                    if (splitURI[1] != null && (component = this.getComponent(scheme = splitURI[0])) != null && (answer = component.createEndpoint(uri)) != null && this.log.isDebugEnabled()) {
                        this.log.debug((Object)(uri + " converted to endpoint: " + answer + " by component: " + component));
                    }
                    if (answer == null) {
                        answer = this.createEndpoint(uri);
                    }
                    if (answer != null) {
                        this.addService(answer);
                        answer = this.addEndpointToRegistry(uri, answer);
                    }
                }
                catch (Exception e) {
                    throw new ResolveEndpointFailedException(uri, e);
                }
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    @Override
    public void addRegisterEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.endpoints.put(this.getEndpointKey(endpoint.getEndpointUri()), newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        ObjectHelper.notEmpty(uri, "uri");
        ObjectHelper.notNull(endpoint, "endpoint");
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
        return endpoint;
    }

    protected static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        return uri;
    }

    protected EndpointKey getEndpointKey(String uri) {
        return new EndpointKey(uri);
    }

    protected EndpointKey getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint != null && !endpoint.isSingleton()) {
            int counter = this.endpointKeyCounter.incrementAndGet();
            return new EndpointKey(uri + ":" + counter);
        }
        return new EndpointKey(uri);
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    @Override
    public synchronized List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new LinkedHashSet<Route>();
        }
        return new ArrayList<Route>(this.routes);
    }

    @Override
    public Route getRoute(String id) {
        for (Route route : this.getRoutes()) {
            if (!route.getId().equals(id)) continue;
            return route;
        }
        return null;
    }

    @Deprecated
    public void setRoutes(List<Route> routes) {
        throw new UnsupportedOperationException("Overriding existing routes is not supported yet, use addRouteCollection instead");
    }

    synchronized void removeRouteCollection(Collection<Route> routes) {
        if (this.routes != null) {
            this.routes.removeAll(routes);
        }
    }

    synchronized void addRouteCollection(Collection<Route> routes) throws Exception {
        if (this.routes == null) {
            this.routes = new LinkedHashSet<Route>();
        }
        if (routes != null) {
            this.routes.addAll(routes);
        }
    }

    @Override
    public void addRoutes(RoutesBuilder builder) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding routes from builder: " + builder));
        }
        builder.addRoutesToCamelContext(this);
    }

    @Override
    public synchronized RoutesDefinition loadRoutesDefinition(InputStream is) throws Exception {
        Unmarshaller unmarshaller;
        Object result;
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer");
        }
        if ((result = (unmarshaller = this.jaxbContext.createUnmarshaller()).unmarshal(is)) == null) {
            throw new IOException("Cannot unmarshal to routes using JAXB from input stream: " + is);
        }
        RoutesDefinition answer = null;
        if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            answer = new RoutesDefinition();
            answer.getRoutes().add(route);
        } else if (result instanceof RoutesDefinition) {
            answer = (RoutesDefinition)result;
        } else {
            throw new IllegalArgumentException("Unmarshalled object is an unsupported type: " + ObjectHelper.className(result) + " -> " + result);
        }
        return answer;
    }

    @Override
    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
        this.routeDefinitions.addAll(routeDefinitions);
        if (this.shouldStartRoutes()) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Arrays.asList(routeDefinition));
    }

    protected boolean removeRouteDefinition(String key) {
        boolean answer = false;
        Iterator<RouteDefinition> iter = this.routeDefinitions.iterator();
        while (iter.hasNext()) {
            RouteDefinition route = iter.next();
            if (!route.idOrCreate(this.nodeIdFactory).equals(key)) continue;
            iter.remove();
            answer = true;
        }
        return answer;
    }

    @Override
    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.routeDefinitions.removeAll(routeDefinitions);
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        String id = routeDefinition.idOrCreate(this.nodeIdFactory);
        this.stopRoute(id);
        this.removeRoute(id);
    }

    @Override
    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    @Override
    public void startRoute(RouteDefinition route) throws Exception {
        route.prepare();
        ArrayList<Route> routes = new ArrayList<Route>();
        List<RouteContext> routeContexts = route.addRoutes(this, routes);
        RouteService routeService = new RouteService(this, route, routeContexts, routes);
        this.startRouteService(routeService, true);
    }

    @Override
    public void stopRoute(RouteDefinition route) throws Exception {
        this.stopRoute(route.idOrCreate(this.nodeIdFactory));
    }

    @Override
    public synchronized void startRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            this.startRouteService(routeService, false);
        }
    }

    @Override
    public synchronized void resumeRoute(String routeId) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.startRoute(routeId);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            this.resumeRouteService(routeService);
        }
    }

    @Override
    public synchronized boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            DefaultRouteStartupOrder route = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            boolean completed = this.getShutdownStrategy().shutdown(this, route, timeout, timeUnit, abortAfterTimeout);
            if (completed) {
                routeService.setRemovingRoutes(false);
                this.stopRouteService(routeService);
            } else {
                this.startRouteService(routeService, false);
            }
            return completed;
        }
        return false;
    }

    @Override
    public synchronized void stopRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes);
            routeService.setRemovingRoutes(false);
            this.stopRouteService(routeService);
        }
    }

    @Override
    public synchronized void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes, timeout, timeUnit);
            routeService.setRemovingRoutes(false);
            this.stopRouteService(routeService);
        }
    }

    @Override
    public synchronized void shutdownRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes);
            routeService.setRemovingRoutes(true);
            this.stopRouteService(routeService);
        }
    }

    @Override
    public synchronized void shutdownRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().shutdown(this, routes, timeout, timeUnit);
            routeService.setRemovingRoutes(true);
            this.stopRouteService(routeService);
        }
    }

    @Override
    public synchronized boolean removeRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            if (this.getRouteStatus(routeId).isStopped()) {
                routeService.setRemovingRoutes(true);
                this.shutdownRouteService(routeService);
                this.removeRouteDefinition(routeId);
                ServiceHelper.stopAndShutdownServices(routeService);
                this.routeServices.remove(routeId);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized void suspendRoute(String routeId) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.stopRoute(routeId);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().suspend(this, routes);
            routeService.setRemovingRoutes(false);
            this.suspendRouteService(routeService);
        }
    }

    @Override
    public synchronized void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        if (!this.routeSupportsSuspension(routeId)) {
            this.stopRoute(routeId, timeout, timeUnit);
            return;
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
            DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoutes().iterator().next(), routeService);
            routes.add(order);
            this.getShutdownStrategy().suspend(this, routes, timeout, timeUnit);
            routeService.setRemovingRoutes(false);
            this.suspendRouteService(routeService);
        }
    }

    @Override
    public void addService(Object object) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                if (service instanceof Endpoint) {
                    strategy.onEndpointAdd((Endpoint)service);
                    continue;
                }
                strategy.onServiceAdd(this, service, null);
            }
            boolean singleton = true;
            if (service instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)service)).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint)) {
                this.servicesToClose.add(service);
            }
        }
        this.startServices(object);
    }

    @Override
    public boolean hasService(Object object) {
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.servicesToClose.contains(service);
        }
        return false;
    }

    @Override
    public void addStartupListener(StartupListener listener) throws Exception {
        if (this.isStarted()) {
            listener.onCamelContextStarted(this, true);
        } else {
            this.startupListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language resolveLanguage(String language) {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)((Object)answer)).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, this);
            if (answer != null) {
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    @Override
    public String resolvePropertyPlaceholders(String text) throws Exception {
        if (text != null && !text.startsWith("properties:") && text.contains("{{")) {
            Component component = this.hasComponent("properties");
            if (component == null) {
                component = this.getRegistry().lookup("properties", Component.class);
            }
            if (component == null) {
                throw new IllegalArgumentException("PropertiesComponent with name properties must be defined in CamelContext to support property placeholders.");
            }
            PropertiesComponent pc = this.getComponent("properties", PropertiesComponent.class);
            String answer = pc.parseUri(text);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Resolved text: " + text + " -> " + answer));
            }
            return answer;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            DefaultCamelContext defaultCamelContext = this;
            synchronized (defaultCamelContext) {
                this.typeConverter = this.createTypeConverter();
                try {
                    this.addService(this.typeConverter);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            if (this.typeConverter == null) {
                this.getTypeConverter();
            }
            if (this.typeConverter instanceof TypeConverterRegistry) {
                this.typeConverterRegistry = (TypeConverterRegistry)((Object)this.typeConverter);
            }
        }
        return this.typeConverterRegistry;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = typeConverterRegistry;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        if (this.languageResolver == null) {
            this.languageResolver = new DefaultLanguageResolver();
        }
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
            this.setRegistry(this.registry);
        }
        return this.registry;
    }

    public void setJndiContext(Context jndiContext) {
        this.setRegistry(new JndiRegistry(jndiContext));
    }

    public void setRegistry(Registry registry) {
        if (!(registry instanceof PropertyPlaceholderDelegateRegistry)) {
            registry = new PropertyPlaceholderDelegateRegistry(this, registry);
        }
        this.registry = registry;
    }

    @Override
    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    public void setLifecycleStrategies(List<LifecycleStrategy> lifecycleStrategies) {
        this.lifecycleStrategies = lifecycleStrategies;
    }

    @Override
    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategies.add(lifecycleStrategy);
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.getId().equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
        if (interceptStrategy instanceof Tracer) {
            this.setTracing(true);
        } else if (interceptStrategy instanceof HandleFault) {
            this.setHandleFault(true);
        } else if (interceptStrategy instanceof StreamCaching) {
            this.setStreamCaching(true);
        } else if (interceptStrategy instanceof Delayer) {
            this.setDelayer(((Delayer)interceptStrategy).getDelay());
        }
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        return this.trace;
    }

    @Override
    public Boolean isHandleFault() {
        return this.handleFault;
    }

    @Override
    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public Long getDelayer() {
        return this.delay;
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public ProducerTemplate createProducerTemplate() {
        int size = CamelContextHelper.getMaximumCachePoolSize(this);
        return this.createProducerTemplate(size);
    }

    @Override
    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        DefaultProducerTemplate answer = new DefaultProducerTemplate(this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startServices(answer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ConsumerTemplate createConsumerTemplate() {
        int size = CamelContextHelper.getMaximumCachePoolSize(this);
        return this.createConsumerTemplate(size);
    }

    @Override
    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this);
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startServices(answer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @Override
    public void setProducerServicePool(ServicePool<Endpoint, Producer> producerServicePool) {
        this.producerServicePool = producerServicePool;
    }

    @Override
    public ServicePool<Endpoint, Producer> getProducerServicePool() {
        return this.producerServicePool;
    }

    @Override
    public String getUptime() {
        if (this.startDate == null) {
            return "not started";
        }
        long delta = new Date().getTime() - this.startDate.getTime();
        return TimeUtils.printDuration(delta);
    }

    @Override
    protected void doSuspend() throws Exception {
        EventHelper.notifyCamelContextSuspending(this);
        this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is suspending"));
        StopWatch watch = new StopWatch();
        for (Map.Entry<String, RouteService> entry : this.getRouteServices().entrySet()) {
            if (!entry.getValue().getStatus().isStarted()) continue;
            this.suspendedRouteServices.put(entry.getKey(), entry.getValue());
        }
        ArrayList<RouteStartupOrder> orders = new ArrayList<RouteStartupOrder>();
        for (Map.Entry<String, RouteService> entry : this.suspendedRouteServices.entrySet()) {
            Route route = entry.getValue().getRoutes().iterator().next();
            Integer order = entry.getValue().getRouteDefinition().getStartupOrder();
            if (order == null) {
                order = this.defaultRouteStartupOrder++;
            }
            orders.add(new DefaultRouteStartupOrder(order, route, entry.getValue()));
        }
        this.getShutdownStrategy().suspend(this, orders);
        for (RouteService service : this.suspendedRouteServices.values()) {
            if (this.routeSupportsSuspension(service.getId())) {
                service.suspend();
                continue;
            }
            service.stop();
        }
        watch.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is suspended in " + TimeUtils.printDuration(watch.taken())));
        }
        EventHelper.notifyCamelContextSuspended(this);
    }

    @Override
    protected void doResume() throws Exception {
        try {
            EventHelper.notifyCamelContextResuming(this);
            this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is resuming"));
            StopWatch watch = new StopWatch();
            this.doStartOrResumeRoutes(this.suspendedRouteServices, false, true, true, false);
            for (RouteService service : this.suspendedRouteServices.values()) {
                if (this.routeSupportsSuspension(service.getId())) {
                    service.resume();
                    continue;
                }
                service.start();
            }
            watch.stop();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Resumed " + this.suspendedRouteServices.size() + " routes"));
                this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") resumed in " + TimeUtils.printDuration(watch.taken())));
            }
            this.suspendedRouteServices.clear();
            EventHelper.notifyCamelContextResumed(this);
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextResumeFailed(this, e);
            throw e;
        }
    }

    @Override
    public void start() throws Exception {
        this.startDate = new Date();
        this.stopWatch.restart();
        this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is starting"));
        this.doNotStartRoutesOnFirstStart = !this.firstStartDone && this.isAutoStartup() == false;
        this.firstStartDone = true;
        super.start();
        this.stopWatch.stop();
        if (this.log.isInfoEnabled()) {
            int started = 0;
            for (Route route : this.getRoutes()) {
                if (!this.getRouteStatus(route.getId()).isStarted()) continue;
                ++started;
            }
            this.log.info((Object)("Total " + this.getRoutes().size() + " routes, of which " + started + " is started."));
            this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") started in " + TimeUtils.printDuration(this.stopWatch.taken())));
        }
        EventHelper.notifyCamelContextStarted(this);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        try {
            this.doStartCamel();
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextStartupFailed(this, e);
            throw e;
        }
    }

    private void doStartCamel() throws Exception {
        if (this.isStreamCaching().booleanValue() && StreamCaching.getStreamCaching(this) == null) {
            this.log.info((Object)("StreamCaching is enabled on CamelContext: " + this.getName()));
            this.addInterceptStrategy(new StreamCaching());
        }
        if (this.isTracing().booleanValue()) {
            this.log.info((Object)("Tracing is enabled on CamelContext: " + this.getName()));
        }
        if (this.isHandleFault().booleanValue() && HandleFault.getHandleFault(this) == null) {
            this.log.info((Object)("HandleFault is enabled on CamelContext: " + this.getName()));
            this.addInterceptStrategy(new HandleFault());
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L && Delayer.getDelayer(this) == null) {
            long millis = this.getDelayer();
            this.log.info((Object)("Delayer is enabled with: " + millis + " ms. on CamelContext: " + this.getName()));
            this.addInterceptStrategy(new Delayer(millis));
        }
        if (this.getDebugger() != null) {
            this.log.info((Object)("Debugger: " + this.getDebugger() + " is enabled on CamelContext: " + this.getName()));
            this.getDebugger().setCamelContext(this);
            this.startServices(this.getDebugger());
            this.addInterceptStrategy(new Debug(this.getDebugger()));
        }
        this.getManagementStrategy().start();
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStart(this);
            }
            catch (VetoCamelContextStartException e) {
                this.log.warn((Object)("Lifecycle strategy vetoed starting CamelContext (" + this.getName() + ")"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.log.warn((Object)("Lifecycle strategy " + strategy + " failed starting CamelContext (" + this.getName() + ")"), (Throwable)e);
                throw e;
            }
        }
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (notifier instanceof Service) {
                Service service = (Service)((Object)notifier);
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onServiceAdd(this, service, null);
                }
            }
            this.startServices(notifier);
        }
        EventHelper.notifyCamelContextStarting(this);
        this.forceLazyInitialization();
        this.addService(this.executorServiceStrategy);
        this.addService(this.producerServicePool);
        this.addService(this.inflightRepository);
        this.addService(this.shutdownStrategy);
        this.startServices(this.components.values());
        this.startRouteDefinitions(this.routeDefinitions);
        if (this.doNotStartRoutesOnFirstStart) {
            this.log.info((Object)"Cannot start routes as CamelContext has been configured with autoStartup=false");
        }
        this.doStartOrResumeRoutes(this.routeServices, true, !this.doNotStartRoutesOnFirstStart, false, true);
    }

    @Override
    protected synchronized void doStop() throws Exception {
        this.stopWatch.restart();
        this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is shutting down"));
        EventHelper.notifyCamelContextStopping(this);
        try {
            this.shutdownStrategy.shutdown(this, this.getRouteStartupOrder());
        }
        catch (Throwable e) {
            this.log.warn((Object)"Error occurred while shutting down routes. This exception will be ignored.", e);
        }
        this.getRouteStartupOrder().clear();
        this.shutdownServices(this.routeServices.values());
        this.suspendedRouteServices.clear();
        ServiceHelper.stopAndShutdownService(this.getDebugger());
        this.shutdownServices(this.endpoints.values());
        this.endpoints.clear();
        this.shutdownServices(this.components.values());
        this.components.clear();
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStop(this);
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Error occurred while stopping lifecycle strategies. This exception will be ignored.", e);
        }
        this.shutdownServices(this.servicesToClose);
        this.servicesToClose.clear();
        EventHelper.notifyCamelContextStopped(this);
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            this.shutdownServices(notifier);
        }
        this.shutdownServices(this.managementStrategy);
        this.forceStopLazyInitialization();
        this.stopWatch.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Uptime: " + this.getUptime()));
            this.log.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext: " + this.getName() + ") is shutdown in " + TimeUtils.printDuration(this.stopWatch.taken())));
        }
        this.startDate = null;
    }

    protected void doStartOrResumeRoutes(Map<String, RouteService> routeServices, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes) throws Exception {
        LinkedHashMap<String, RouteService> filtered = new LinkedHashMap<String, RouteService>();
        for (Map.Entry<String, RouteService> entry : routeServices.entrySet()) {
            Consumer consumer = entry.getValue().getRoutes().iterator().next().getConsumer();
            boolean startable = consumer instanceof SuspendableService ? ((SuspendableService)((Object)consumer)).isSuspended() : (consumer instanceof ServiceSupport ? ((ServiceSupport)((Object)consumer)).getStatus().isStartable() : entry.getValue().getStatus().isStartable());
            if (!startable) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        if (!filtered.isEmpty()) {
            this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, filtered.values());
        }
        for (StartupListener startup : this.startupListeners) {
            startup.onCamelContextStarted(this, this.isStarted());
        }
    }

    protected boolean routeSupportsSuspension(String routeId) {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            return routeService.getRoutes().iterator().next().supportsSuspension();
        }
        return false;
    }

    private void shutdownServices(Object service) {
        try {
            ServiceHelper.stopAndShutdownService(service);
        }
        catch (Throwable e) {
            this.log.warn((Object)("Error occurred while shutting down service: " + service + ". This exception will be ignored."), e);
            EventHelper.notifyServiceStopFailure(this, service, e);
        }
    }

    private void shutdownServices(Collection<?> services) {
        this.shutdownServices(services, true);
    }

    private void shutdownServices(Collection<?> services, boolean reverse) {
        Collection list = CastUtils.cast(services);
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            this.shutdownServices(service);
        }
    }

    private void startServices(Object service) throws Exception {
        if (service instanceof Collection) {
            for (Object element : (Collection)service) {
                this.startServices(element);
            }
        }
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)service;
            this.addStartupListener(listener);
        }
        ServiceHelper.startService(service);
    }

    private void resumeServices(Object service) throws Exception {
        if (service instanceof Collection) {
            for (Object element : (Collection)service) {
                this.resumeServices(element);
            }
        }
        ServiceHelper.resumeService(service);
    }

    private void stopServices(Object service) throws Exception {
        try {
            ServiceHelper.stopService(service);
        }
        catch (Exception e) {
            EventHelper.notifyServiceStopFailure(this, service, e);
            throw e;
        }
    }

    protected void startRouteDefinitions(Collection<RouteDefinition> list) throws Exception {
        if (list != null) {
            for (RouteDefinition route : list) {
                this.startRoute(route);
            }
        }
    }

    protected synchronized void startRouteService(RouteService routeService, boolean addingRoutes) throws Exception {
        if (routeService.getStatus().isSuspended()) {
            this.resumeRouteService(routeService);
        } else {
            this.routeServices.put(routeService.getId(), routeService);
            if (this.shouldStartRoutes()) {
                this.safelyStartRouteServices(true, true, true, false, addingRoutes, routeService);
                boolean autoStartup = routeService.getRouteDefinition().isAutoStartup(this);
                if (!addingRoutes || autoStartup) {
                    routeService.start();
                }
            }
        }
    }

    protected synchronized void resumeRouteService(RouteService routeService) throws Exception {
        if (!routeService.getStatus().isSuspended()) {
            this.startRouteService(routeService, false);
        } else if (this.shouldStartRoutes()) {
            this.safelyStartRouteServices(true, false, true, true, false, routeService);
            routeService.resume();
        }
    }

    protected synchronized void stopRouteService(RouteService routeService) throws Exception {
        routeService.stop();
        for (Route route : routeService.getRoutes()) {
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)("Route: " + route.getId() + " stopped, was consuming from: " + route.getConsumer().getEndpoint()));
        }
    }

    protected synchronized void shutdownRouteService(RouteService routeService) throws Exception {
        routeService.shutdown();
        for (Route route : routeService.getRoutes()) {
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)("Route: " + route.getId() + " shutdown and removed, was consuming from: " + route.getConsumer().getEndpoint()));
        }
    }

    protected synchronized void suspendRouteService(RouteService routeService) throws Exception {
        routeService.suspend();
        for (Route route : routeService.getRoutes()) {
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)("Route: " + route.getId() + " suspended, was consuming from: " + route.getConsumer().getEndpoint()));
        }
    }

    protected synchronized void safelyStartRouteServices(boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, Collection<RouteService> routeServices) throws Exception {
        TreeMap<Integer, DefaultRouteStartupOrder> inputs = new TreeMap<Integer, DefaultRouteStartupOrder>();
        for (RouteService routeService : routeServices) {
            DefaultRouteStartupOrder order = this.doPrepareRouteToBeStarted(routeService);
            if (checkClash) {
                this.doCheckStartupOrderClash(order, inputs);
            }
            inputs.put(order.getStartupOrder(), order);
        }
        this.doWarmUpRoutes(inputs, startConsumer);
        if (startConsumer) {
            if (resumeConsumer) {
                this.doResumeRouteConsumers(inputs, addingRoutes);
            } else {
                this.doStartRouteConsumers(inputs, addingRoutes);
            }
        }
        inputs.clear();
    }

    protected synchronized void safelyStartRouteServices(boolean forceAutoStart, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, RouteService ... routeServices) throws Exception {
        this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, Arrays.asList(routeServices));
    }

    private DefaultRouteStartupOrder doPrepareRouteToBeStarted(RouteService routeService) {
        Integer startupOrder = routeService.getRouteDefinition().getStartupOrder();
        if (startupOrder == null) {
            startupOrder = this.defaultRouteStartupOrder++;
        }
        Route route = routeService.getRoutes().iterator().next();
        return new DefaultRouteStartupOrder(startupOrder, route, routeService);
    }

    private boolean doCheckStartupOrderClash(DefaultRouteStartupOrder answer, Map<Integer, DefaultRouteStartupOrder> inputs) throws FailedToStartRouteException {
        DefaultRouteStartupOrder other = inputs.get(answer.getStartupOrder());
        if (other != null && answer != other) {
            String otherId = other.getRoute().getId();
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        for (RouteStartupOrder order : this.routeStartupOrder) {
            String otherId = order.getRoute().getId();
            if (answer.getRoute().getId().equals(otherId) || answer.getStartupOrder() != order.getStartupOrder()) continue;
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        return true;
    }

    private void doWarmUpRoutes(Map<Integer, DefaultRouteStartupOrder> inputs, boolean autoStartup) throws Exception {
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            RouteService routeService = entry.getValue().getRouteService();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Warming up route id: " + routeService.getId() + " having autoStartup=" + autoStartup));
            }
            routeService.warmUp();
        }
    }

    private void doResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, true, addingRoutes);
    }

    private void doStartRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, false, addingRoutes);
    }

    private void doStartOrResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean resumeOnly, boolean addingRoute) throws Exception {
        ArrayList<Endpoint> routeInputs = new ArrayList<Endpoint>();
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            Integer order = entry.getKey();
            Route route = entry.getValue().getRoute();
            RouteService routeService = entry.getValue().getRouteService();
            boolean autoStartup = routeService.getRouteDefinition().isAutoStartup(this);
            if (addingRoute && !autoStartup) {
                this.log.info((Object)("Cannot start route " + routeService.getId() + " as its configured with autoStartup=false"));
                continue;
            }
            for (Consumer consumer : routeService.getInputs().values()) {
                Endpoint endpoint = consumer.getEndpoint();
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, routeInputs)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Route: " + route.getId() + " >>> " + route));
                    if (resumeOnly) {
                        this.log.debug((Object)("Resuming consumer (order: " + order + ") on route: " + route.getId()));
                    } else {
                        this.log.debug((Object)("Starting consumer (order: " + order + ") on route: " + route.getId()));
                    }
                }
                if (resumeOnly && route.supportsSuspension()) {
                    this.resumeServices(consumer);
                    this.log.info((Object)("Route: " + route.getId() + " resumed and consuming from: " + endpoint));
                } else {
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onServiceAdd(this, consumer, route);
                    }
                    this.startServices(consumer);
                    this.log.info((Object)("Route: " + route.getId() + " started and consuming from: " + endpoint));
                }
                routeInputs.add(endpoint);
                boolean found = false;
                for (RouteStartupOrder other : this.routeStartupOrder) {
                    if (other.getRoute().getId() != route.getId()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.routeStartupOrder.add(entry.getValue());
            }
            routeService.start(false);
        }
    }

    private boolean doCheckMultipleConsumerSupportClash(Endpoint endpoint, List<Endpoint> routeInputs) {
        boolean multipleConsumersSupported = false;
        if (endpoint instanceof MultipleConsumersSupport) {
            multipleConsumersSupported = ((MultipleConsumersSupport)((Object)endpoint)).isMultipleConsumersSupported();
        }
        if (multipleConsumersSupported) {
            return true;
        }
        return !routeInputs.contains(endpoint);
    }

    protected void forceLazyInitialization() {
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverterRegistry();
        this.getTypeConverter();
    }

    protected void forceStopLazyInitialization() {
        this.injector = null;
        this.languageResolver = null;
        this.typeConverterRegistry = null;
        this.typeConverter = null;
    }

    protected TypeConverter createTypeConverter() {
        BaseTypeConverterRegistry answer = this.isLazyLoadTypeConverters() != false ? new LazyLoadingTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder()) : new DefaultTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder());
        this.setTypeConverterRegistry(answer);
        return answer;
    }

    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new ReflectionInjector();
        }
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        return new JndiRegistry();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookup(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public FactoryFinder getDefaultFactoryFinder() {
        if (this.defaultFactoryFinder == null) {
            this.defaultFactoryFinder = this.factoryFinderResolver.resolveDefaultFactoryFinder(this.getClassResolver());
        }
        return this.defaultFactoryFinder;
    }

    @Override
    public void setFactoryFinderResolver(FactoryFinderResolver resolver) {
        this.factoryFinderResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinder getFactoryFinder(String path) throws NoFactoryAvailableException {
        Map<String, FactoryFinder> map = this.factories;
        synchronized (map) {
            FactoryFinder answer = this.factories.get(path);
            if (answer == null) {
                answer = this.factoryFinderResolver.resolveFactoryFinder(this.getClassResolver(), path);
                this.factories.put(path, answer);
            }
            return answer;
        }
    }

    @Override
    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public PackageScanClassResolver getPackageScanClassResolver() {
        return this.packageScanClassResolver;
    }

    @Override
    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = packageScanClassResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComponentNames() {
        Map<String, Component> map = this.components;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.components.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLanguageNames() {
        Map<String, Language> map = this.languages;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.languages.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    @Override
    public NodeIdFactory getNodeIdFactory() {
        return this.nodeIdFactory;
    }

    @Override
    public void setNodeIdFactory(NodeIdFactory idFactory) {
        this.nodeIdFactory = idFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementStrategy getManagementStrategy() {
        AtomicBoolean atomicBoolean = this.managementStrategyInitialized;
        synchronized (atomicBoolean) {
            if (this.managementStrategyInitialized.compareAndSet(false, true)) {
                this.managementStrategy = this.createManagementStrategy();
            }
            return this.managementStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        AtomicBoolean atomicBoolean = this.managementStrategyInitialized;
        synchronized (atomicBoolean) {
            if (this.managementStrategyInitialized.get()) {
                this.log.warn((Object)("Resetting ManagementStrategy for context " + this.getName()));
            }
            this.managementStrategy = managementStrategy;
            this.managementStrategyInitialized.set(true);
        }
    }

    @Override
    public InterceptStrategy getDefaultTracer() {
        if (this.defaultTracer == null) {
            this.defaultTracer = new Tracer();
        }
        return this.defaultTracer;
    }

    @Override
    public void setDefaultTracer(InterceptStrategy defaultTracer) {
        this.defaultTracer = defaultTracer;
    }

    @Override
    public void disableJMX() {
        this.disableJMX = true;
    }

    @Override
    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    @Override
    public void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = repository;
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    @Override
    public Boolean isLazyLoadTypeConverters() {
        return this.lazyLoadTypeConverters != null && this.lazyLoadTypeConverters != false;
    }

    @Override
    public void setLazyLoadTypeConverters(Boolean lazyLoadTypeConverters) {
        this.lazyLoadTypeConverters = lazyLoadTypeConverters;
    }

    @Override
    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    @Override
    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    @Override
    public DataFormatResolver getDataFormatResolver() {
        return this.dataFormatResolver;
    }

    @Override
    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        this.dataFormatResolver = dataFormatResolver;
    }

    @Override
    public DataFormat resolveDataFormat(String name) {
        return this.dataFormatResolver.resolveDataFormat(name, this);
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        return this.dataFormatResolver.resolveDataFormatDefinition(name, this);
    }

    @Override
    public ShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    @Override
    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public ExecutorServiceStrategy getExecutorServiceStrategy() {
        return this.executorServiceStrategy;
    }

    @Override
    public void setExecutorServiceStrategy(ExecutorServiceStrategy executorServiceStrategy) {
        this.executorServiceStrategy = executorServiceStrategy;
    }

    @Override
    public ProcessorFactory getProcessorFactory() {
        return this.processorFactory;
    }

    @Override
    public void setProcessorFactory(ProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
    }

    @Override
    public Debugger getDebugger() {
        return this.debugger;
    }

    @Override
    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public UuidGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    @Override
    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }

    protected ManagementStrategy createManagementStrategy() {
        DefaultManagementStrategy answer;
        if (this.disableJMX.booleanValue() || Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            this.log.info((Object)"JMX is disabled. Using DefaultManagementStrategy.");
            answer = new DefaultManagementStrategy();
        } else {
            try {
                this.log.info((Object)"JMX enabled. Using ManagedManagementStrategy.");
                answer = new ManagedManagementStrategy(new DefaultManagementAgent(this));
                this.startServices(answer);
                this.lifecycleStrategies.add(0, new DefaultManagementLifecycleStrategy(this));
            }
            catch (NoClassDefFoundError e) {
                answer = null;
                this.log.warn((Object)("Cannot find needed classes for JMX lifecycle strategy. Needed class is in spring-context.jar using Spring 2.5 or newer (spring-jmx.jar using Spring 2.0.x). NoClassDefFoundError: " + e.getMessage()));
            }
            catch (Exception e) {
                answer = null;
                this.log.warn((Object)"Cannot create JMX lifecycle strategy. Fallback to using DefaultManagementStrategy (non JMX).", (Throwable)e);
            }
        }
        if (answer == null) {
            this.log.warn((Object)"Cannot use JMX. Fallback to using DefaultManagementStrategy (non JMX).");
            answer = new DefaultManagementStrategy();
        }
        if (answer instanceof CamelContextAware) {
            CamelContextAware aware = answer;
            aware.setCamelContext(this);
        }
        return answer;
    }

    public String toString() {
        return "CamelContext(" + this.getName() + ")";
    }

    public static void setContextCounter(int value) {
        DefaultCamelContextNameStrategy.setCounter(value);
    }

    private static UuidGenerator createDefaultUuidGenerator() {
        if (System.getProperty("com.google.appengine.runtime.environment") != null) {
            return new JavaUuidGenerator();
        }
        return new ActiveMQUuidGenerator();
    }
}

