/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;

public final class PipelineHelper {
    private PipelineHelper() {
    }

    public static boolean continueProcessing(Exchange exchange, String message, Log log) {
        boolean doStop;
        boolean exceptionHandled = ExchangeHelper.hasExceptionBeenHandledByErrorHandler(exchange);
        if (exchange.isFailed() || exchange.isRollbackOnly() || exceptionHandled) {
            StringBuilder sb;
            if (exchange.hasOut() && exchange.getOut().isFault() && exchange.getException() != null) {
                sb = new StringBuilder();
                sb.append("Message exchange has failed: " + message + " for exchange: ").append(exchange);
                sb.append(" Warning: Both fault and exception exists on the exchange, its best practice to only set one of them.");
                sb.append(" Exception: ").append(exchange.getException());
                sb.append(" Fault: ").append(exchange.getOut());
                if (exceptionHandled) {
                    sb.append(" Handled by the error handler.");
                }
                log.warn((Object)sb.toString());
            }
            if (log.isDebugEnabled()) {
                sb = new StringBuilder();
                sb.append("Message exchange has failed: " + message + " for exchange: ").append(exchange);
                if (exchange.isRollbackOnly()) {
                    sb.append(" Marked as rollback only.");
                }
                if (exchange.getException() != null) {
                    sb.append(" Exception: ").append(exchange.getException());
                }
                if (exchange.hasOut() && exchange.getOut().isFault()) {
                    sb.append(" Fault: ").append(exchange.getOut());
                }
                if (exceptionHandled) {
                    sb.append(" Handled by the error handler.");
                }
                log.debug((Object)sb.toString());
            }
            return false;
        }
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, exchange, stop).booleanValue())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ExchangeId: " + exchange.getExchangeId() + " is marked to stop routing: " + exchange));
            }
            return false;
        }
        return true;
    }
}

