/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class EndpointMessageListener
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(EndpointMessageListener.class);
    private ExceptionHandler exceptionHandler;
    private JmsEndpoint endpoint;
    private Processor processor;
    private JmsBinding binding;
    private boolean eagerLoadingOfProperties;
    private Object replyToDestination;
    private JmsOperations template;
    private boolean disableReplyTo;

    public EndpointMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
        endpoint.getConfiguration().configure(this);
    }

    public void onMessage(javax.jms.Message message) {
        LOG.trace((Object)"onMessage START");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)this.endpoint) + " consumer received JMS message: " + message));
        }
        RuntimeCamelException rce = null;
        try {
            String correlationId;
            Object replyDestination = this.getReplyToDestination(message);
            boolean sendReply = replyDestination != null && !this.disableReplyTo;
            Exchange exchange = this.createExchange(message, replyDestination);
            if (this.eagerLoadingOfProperties) {
                exchange.getIn().getHeaders();
            }
            if ((correlationId = message.getJMSCorrelationID()) != null) {
                LOG.debug((Object)("Received Message has JMSCorrelationID [" + correlationId + "]"));
            }
            LOG.trace((Object)"onMessage.process START");
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"onMessage.process END");
            }
            Message body = null;
            Exception cause = null;
            if (exchange.isFailed() || exchange.isRollbackOnly()) {
                if (exchange.isRollbackOnly()) {
                    rce = ObjectHelper.wrapRuntimeCamelException((Throwable)new RollbackExchangeException(exchange));
                } else if (exchange.getException() != null) {
                    if (this.endpoint.isTransferException()) {
                        body = null;
                        cause = exchange.getException();
                    } else {
                        rce = ObjectHelper.wrapRuntimeCamelException((Throwable)exchange.getException());
                    }
                } else if (exchange.hasOut() && exchange.getOut().isFault()) {
                    body = exchange.getOut();
                    cause = null;
                }
            } else if (sendReply && exchange.getPattern().isOutCapable() && exchange.hasOut()) {
                body = exchange.getOut();
                cause = null;
            }
            if (rce == null && sendReply && (body != null || cause != null)) {
                LOG.trace((Object)"onMessage.sendReply START");
                if (replyDestination instanceof Destination) {
                    this.sendReply((Destination)replyDestination, message, exchange, body, cause);
                } else {
                    this.sendReply((String)replyDestination, message, exchange, body, cause);
                }
                LOG.trace((Object)"onMessage.sendReply END");
            }
        }
        catch (Exception e) {
            rce = ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (rce != null) {
            this.handleException((Throwable)rce);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("onMessage END throwing exception: " + rce.getMessage()));
            }
            throw rce;
        }
        LOG.trace((Object)"onMessage END");
    }

    public Exchange createExchange(javax.jms.Message message, Object replyDestination) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this.endpoint, this.endpoint.getExchangePattern());
        JmsBinding binding = this.getBinding();
        exchange.setProperty("CamelBinding", (Object)binding);
        exchange.setIn((Message)new JmsMessage(message, binding));
        if (replyDestination != null && !this.disableReplyTo && !exchange.getPattern().isOutCapable()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JmsBinding(this.endpoint);
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public synchronized JmsOperations getTemplate() {
        if (this.template == null) {
            this.template = this.endpoint.createInOnlyTemplate();
        }
        return this.template;
    }

    public void setTemplate(JmsOperations template) {
        this.template = template;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public Object getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    protected String determineCorrelationId(javax.jms.Message message) throws JMSException {
        String messageId = message.getJMSMessageID();
        String correlationId = message.getJMSCorrelationID();
        if (this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID()) {
            return messageId;
        }
        if (ObjectHelper.isEmpty((Object)correlationId)) {
            return messageId;
        }
        return correlationId;
    }

    protected void sendReply(Destination replyDestination, final javax.jms.Message message, final Exchange exchange, final Message out, final Exception cause) {
        if (replyDestination == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot send reply message as there is no replyDestination for: " + out));
            }
            return;
        }
        this.getTemplate().send(replyDestination, new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session, cause);
                String correlationID = EndpointMessageListener.this.determineCorrelationId(message);
                reply.setJMSCorrelationID(correlationID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)((Object)((Object)EndpointMessageListener.this.endpoint) + " sending reply JMS message [correlationId:" + correlationID + "]: " + reply));
                }
                return reply;
            }
        });
    }

    protected void sendReply(String replyDestination, final javax.jms.Message message, final Exchange exchange, final Message out, final Exception cause) {
        if (replyDestination == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot send reply message as there is no replyDestination for: " + out));
            }
            return;
        }
        this.getTemplate().send(replyDestination, new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session, cause);
                String correlationID = EndpointMessageListener.this.determineCorrelationId(message);
                reply.setJMSCorrelationID(correlationID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)((Object)((Object)EndpointMessageListener.this.endpoint) + " sending reply JMS message [correlationId:" + correlationID + "]: " + reply));
                }
                return reply;
            }
        });
    }

    protected Object getReplyToDestination(javax.jms.Message message) throws JMSException {
        Object destination = this.getReplyToDestination();
        if (destination == null) {
            destination = JmsMessageHelper.getJMSReplyTo(message);
        }
        return destination;
    }

    protected void handleException(Throwable t) {
        this.getExceptionHandler().handleException(t);
    }
}

