/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.util.ArrayList;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.EndpointHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestEndpoint
extends MockEndpoint {
    private static final transient Log LOG = LogFactory.getLog(TestEndpoint.class);
    private final Endpoint expectedMessageEndpoint;
    private long timeout = 2000L;

    public TestEndpoint(String endpointUri, Component component, Endpoint expectedMessageEndpoint) {
        super(endpointUri, component);
        this.expectedMessageEndpoint = expectedMessageEndpoint;
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Consuming expected messages from: " + this.expectedMessageEndpoint));
        }
        final ArrayList expectedBodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.expectedMessageEndpoint, (Processor)new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object body = TestEndpoint.this.getInBody(exchange);
                expectedBodies.add(body);
            }
        }, (long)this.timeout);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received: " + expectedBodies.size() + " expected message(s) from: " + this.expectedMessageEndpoint));
        }
        this.expectedBodiesReceived(expectedBodies);
    }

    protected Object getInBody(Exchange exchange) {
        return exchange.getIn().getBody();
    }
}

