/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusListenerCollection;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesFocusEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;

public abstract class FocusWidget
extends Widget
implements SourcesClickEvents,
SourcesFocusEvents,
HasFocus,
SourcesKeyboardEvents {
    private static final FocusImpl impl = FocusImpl.getFocusImplForWidget();
    private ClickListenerCollection clickListeners;
    private FocusListenerCollection focusListeners;
    private KeyboardListenerCollection keyboardListeners;

    protected static FocusImpl getFocusImpl() {
        return impl;
    }

    protected FocusWidget() {
    }

    protected FocusWidget(com.google.gwt.dom.client.Element elem) {
        this.setElement(elem);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
            this.sinkEvents(1);
        }
        this.clickListeners.add(listener);
    }

    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new FocusListenerCollection();
            this.sinkEvents(6144);
        }
        this.focusListeners.add(listener);
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new KeyboardListenerCollection();
            this.sinkEvents(896);
        }
        this.keyboardListeners.add(listener);
    }

    public int getTabIndex() {
        return impl.getTabIndex(this.getElement());
    }

    public boolean isEnabled() {
        return !DOM.getElementPropertyBoolean(this.getElement(), "disabled");
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 2048: 
            case 4096: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 128: 
            case 256: 
            case 512: {
                if (this.keyboardListeners == null) break;
                this.keyboardListeners.fireKeyboardEvent(this, event);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public void setAccessKey(char key) {
        DOM.setElementProperty(this.getElement(), "accessKey", "" + key);
    }

    public void setEnabled(boolean enabled) {
        DOM.setElementPropertyBoolean(this.getElement(), "disabled", !enabled);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            impl.focus(this.getElement());
        } else {
            impl.blur(this.getElement());
        }
    }

    public void setTabIndex(int index) {
        impl.setTabIndex(this.getElement(), index);
    }

    protected void setElement(Element elem) {
        super.setElement(elem);
        this.setTabIndex(0);
    }

    void fireClickListeners() {
        if (this.clickListeners != null) {
            this.clickListeners.fireClick(this);
        }
    }
}

