/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJettyHttpBinding
implements JettyHttpBinding {
    private static final transient Log LOG = LogFactory.getLog(DefaultJettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private boolean throwExceptionOnFailure;
    private boolean transferException;

    public void populateResponse(Exchange exchange, JettyContentExchange httpExchange) throws Exception {
        int responseCode = httpExchange.getResponseStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HTTP responseCode: " + responseCode));
        }
        Message in = exchange.getIn();
        if (!this.isThrowExceptionOnFailure()) {
            this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
        } else if (responseCode >= 100 && responseCode < 300) {
            this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
        } else {
            throw this.populateHttpOperationFailedException(exchange, httpExchange, responseCode);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    protected void populateResponse(Exchange exchange, JettyContentExchange httpExchange, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Message answer = exchange.getOut();
        answer.setHeaders(in.getHeaders());
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        for (Map.Entry<String, String> entry : httpExchange.getHeaders().entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            answer.setHeader(name, (Object)value);
        }
        answer.setBody(this.extractResponseBody(exchange, httpExchange));
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, JettyContentExchange httpExchange, int responseCode) throws IOException {
        String locationHeader;
        String uri = httpExchange.getUrl();
        Map<String, String> headers = httpExchange.getHeaders();
        Object responseBody = this.extractResponseBody(exchange, httpExchange);
        if (this.transferException && responseBody != null && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = responseCode >= 300 && responseCode < 400 ? ((locationHeader = httpExchange.getResponseFields().getStringField("location")) != null ? new HttpOperationFailedException(uri, responseCode, null, locationHeader, headers, copy) : new HttpOperationFailedException(uri, responseCode, null, null, headers, copy)) : new HttpOperationFailedException(uri, responseCode, null, null, headers, copy);
        return answer;
    }

    protected Object extractResponseBody(Exchange exchange, JettyContentExchange httpExchange) throws IOException {
        String contentType = httpExchange.getHeaders().get("Content-Type");
        if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
            try {
                InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)httpExchange.getResponseContentBytes());
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
            }
        }
        return httpExchange.getBody();
    }
}

