/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.JmsMultipleClientsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class ExpiryHogTest
extends JmsMultipleClientsTestSupport {
    boolean sleep = false;
    int numMessages = 4;

    public void testImmediateDispatchWhenCacheDisabled() throws Exception {
        ConnectionFactory f = this.createConnectionFactory();
        this.destination = this.createDestination();
        this.startConsumers(f, this.destination);
        this.sleep = true;
        this.startProducers(f, this.destination, this.numMessages);
        this.allMessagesList.assertMessagesReceived(this.numMessages);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService bs = new BrokerService();
        bs.setDeleteAllMessagesOnStartup(true);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(5000L);
        defaultEntry.setUseCache(false);
        policyMap.setDefaultEntry(defaultEntry);
        bs.setDestinationPolicy(policyMap);
        KahaDBPersistenceAdapter ad = (KahaDBPersistenceAdapter)bs.getPersistenceAdapter();
        ad.setConcurrentStoreAndDispatchQueues(true);
        return bs;
    }

    protected TextMessage createTextMessage(Session session, String initText) throws Exception {
        if (this.sleep) {
            TimeUnit.SECONDS.sleep(10L);
        }
        TextMessage msg = super.createTextMessage(session, initText);
        msg.setJMSExpiration(4000L);
        return msg;
    }

    protected void setUp() throws Exception {
        this.autoFail = false;
        this.persistent = true;
        super.setUp();
    }
}

