/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsBenchmark
extends JmsTestSupport {
    private static final transient Log LOG = LogFactory.getLog(JmsBenchmark.class);
    private static final long SAMPLE_DELAY = Integer.parseInt(System.getProperty("SAMPLE_DELAY", "5000"));
    private static final long SAMPLES = Integer.parseInt(System.getProperty("SAMPLES", "10"));
    private static final long SAMPLE_DURATION = Integer.parseInt(System.getProperty("SAMPLES_DURATION", "60000"));
    private static final int PRODUCER_COUNT = Integer.parseInt(System.getProperty("PRODUCER_COUNT", "10"));
    private static final int CONSUMER_COUNT = Integer.parseInt(System.getProperty("CONSUMER_COUNT", "10"));
    public ActiveMQDestination destination;

    public static Test suite() {
        return JmsBenchmark.suite(JmsBenchmark.class);
    }

    public static void main(String[] args) {
        TestRunner.run(JmsBenchmark.class);
    }

    public void initCombos() {
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST")});
    }

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("broker://(tcp://localhost:0)?persistent=false"));
    }

    protected ConnectionFactory createConnectionFactory() throws URISyntaxException, IOException {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getServer().getConnectURI());
    }

    public void testConcurrentSendReceive() throws Throwable {
        int i;
        final Semaphore connectionsEstablished = new Semaphore(1 - (CONSUMER_COUNT + PRODUCER_COUNT));
        final Semaphore workerDone = new Semaphore(1 - (CONSUMER_COUNT + PRODUCER_COUNT));
        final CountDownLatch sampleTimeDone = new CountDownLatch(1);
        final AtomicInteger producedMessages = new AtomicInteger(0);
        final AtomicInteger receivedMessages = new AtomicInteger(0);
        final Callable producer = new Callable(){

            public Object call() throws JMSException, InterruptedException {
                Connection connection = JmsBenchmark.this.factory.createConnection();
                JmsBenchmark.this.connections.add(connection);
                Session session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)JmsBenchmark.this.destination);
                producer.setDeliveryMode(1);
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(new byte[1024]);
                connection.start();
                connectionsEstablished.release();
                while (!sampleTimeDone.await(0L, TimeUnit.MILLISECONDS)) {
                    producer.send((Message)message);
                    producedMessages.incrementAndGet();
                }
                connection.close();
                workerDone.release();
                return null;
            }
        };
        final Callable consumer = new Callable(){

            public Object call() throws JMSException, InterruptedException {
                Connection connection = JmsBenchmark.this.factory.createConnection();
                JmsBenchmark.this.connections.add(connection);
                Session session = connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer((Destination)JmsBenchmark.this.destination);
                consumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message msg) {
                        receivedMessages.incrementAndGet();
                    }
                });
                connection.start();
                connectionsEstablished.release();
                sampleTimeDone.await();
                connection.close();
                workerDone.release();
                return null;
            }
        };
        final Throwable[] workerError = new Throwable[1];
        for (i = 0; i < PRODUCER_COUNT; ++i) {
            new Thread("Producer:" + i){

                public void run() {
                    try {
                        producer.call();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        workerError[0] = e;
                    }
                }
            }.start();
        }
        for (i = 0; i < CONSUMER_COUNT; ++i) {
            new Thread("Consumer:" + i){

                public void run() {
                    try {
                        consumer.call();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        workerError[0] = e;
                    }
                }
            }.start();
        }
        LOG.info((Object)(this.getName() + ": Waiting for Producers and Consumers to startup."));
        connectionsEstablished.acquire();
        LOG.info((Object)("Producers and Consumers are now running.  Waiting for system to reach steady state: " + (float)SAMPLE_DELAY / 1000.0f + " seconds"));
        Thread.sleep(10000L);
        LOG.info((Object)("Starting sample: " + SAMPLES + " each lasting " + (float)SAMPLE_DURATION / 1000.0f + " seconds"));
        i = 0;
        while ((long)i < SAMPLES) {
            long start = System.currentTimeMillis();
            producedMessages.set(0);
            receivedMessages.set(0);
            Thread.sleep(SAMPLE_DURATION);
            long end = System.currentTimeMillis();
            int r = receivedMessages.get();
            int p = producedMessages.get();
            LOG.info((Object)("published: " + p + " msgs at " + (float)p * 1000.0f / (float)(end - start) + " msgs/sec, " + "consumed: " + r + " msgs at " + (float)r * 1000.0f / (float)(end - start) + " msgs/sec"));
            ++i;
        }
        LOG.info((Object)"Sample done.");
        sampleTimeDone.countDown();
        workerDone.acquire();
        if (workerError[0] != null) {
            throw workerError[0];
        }
    }
}

