/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Random;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsConnectionStartStopTest
extends TestSupport {
    private static final Log LOG = LogFactory.getLog(JmsConnectionStartStopTest.class);
    private Connection startedConnection;
    private Connection stoppedConnection;

    protected void setUp() throws Exception {
        LOG.info((Object)((Object)((Object)this)).getClass().getClassLoader().getResource("log4j.properties"));
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.startedConnection = factory.createConnection();
        this.startedConnection.start();
        this.stoppedConnection = factory.createConnection();
    }

    protected void tearDown() throws Exception {
        this.stoppedConnection.close();
        this.startedConnection.close();
    }

    public void testStoppedConsumerHoldsMessagesTillStarted() throws JMSException {
        Session startedSession = this.startedConnection.createSession(false, 1);
        Session stoppedSession = this.stoppedConnection.createSession(false, 1);
        Topic topic = startedSession.createTopic("test");
        MessageConsumer startedConsumer = startedSession.createConsumer((Destination)topic);
        MessageConsumer stoppedConsumer = stoppedSession.createConsumer((Destination)topic);
        MessageProducer producer = startedSession.createProducer((Destination)topic);
        TextMessage message = startedSession.createTextMessage("Hello");
        producer.send((Message)message);
        Message m = startedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        m = stoppedConsumer.receive(1000L);
        JmsConnectionStartStopTest.assertNull((Object)m);
        this.stoppedConnection.start();
        m = stoppedConsumer.receive(5000L);
        JmsConnectionStartStopTest.assertNotNull((Object)m);
        startedSession.close();
        stoppedSession.close();
    }

    public void testMultipleConnectionStops() throws Exception {
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
        this.stoppedConnection.stop();
        this.testStoppedConsumerHoldsMessagesTillStarted();
    }

    public void testConcurrentSessionCreateWithStart() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(50, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        final Vector exceptions = new Vector();
        final Random rand = new Random();
        Runnable createSessionTask = new Runnable(){

            public void run() {
                try {
                    TimeUnit.MILLISECONDS.sleep(rand.nextInt(10));
                    JmsConnectionStartStopTest.this.stoppedConnection.createSession(false, 1);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        Runnable startStopTask = new Runnable(){

            public void run() {
                try {
                    TimeUnit.MILLISECONDS.sleep(rand.nextInt(10));
                    JmsConnectionStartStopTest.this.stoppedConnection.start();
                    JmsConnectionStartStopTest.this.stoppedConnection.stop();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        for (int i = 0; i < 1000; ++i) {
            executor.execute(createSessionTask);
            executor.execute(startStopTask);
        }
        executor.shutdown();
        JmsConnectionStartStopTest.assertTrue((String)"executor terminated", (boolean)executor.awaitTermination(30L, TimeUnit.SECONDS));
        JmsConnectionStartStopTest.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
    }
}

