/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSendReceiveTestSupport
extends TestSupport
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(JmsSendReceiveTestSupport.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List<Message> messages = this.createConcurrentList();
    protected boolean topic = true;
    protected boolean durable;
    protected int deliveryMode = 2;
    protected final Object lock = new Object();
    protected boolean verbose;

    @Override
    protected void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        LOG.info((Object)("Message count for test case is: " + this.messageCount));
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
    }

    public void testSendReceive() throws Exception {
        this.messages.clear();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug((Object)("About to send a message: " + message + " with text: " + this.data[i]));
            }
            this.sendToProducer(this.producer, this.producerDestination, (Message)message);
            this.messageSent();
        }
        this.assertMessagesAreReceived();
        LOG.info((Object)("" + this.data.length + " messages(s) received, closing down connections"));
    }

    protected void sendToProducer(MessageProducer producer, Destination producerDestination, Message message) throws JMSException {
        producer.send(producerDestination, message);
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void assertMessagesReceivedAreValid(List<Message> receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        int counter = 0;
        if (this.data.length != copyOfMessages.size()) {
            for (TextMessage textMessage : copyOfMessages) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("<== " + counter++ + " = " + textMessage.getText()));
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Not enough messages received", (int)this.data.length, (int)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage textMessage = (TextMessage)receivedMessages.get(i);
            String text = textMessage.getText();
            String stringProperty = textMessage.getStringProperty("stringProperty");
            int intProperty = textMessage.getIntProperty("intProperty");
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.info((Object)("Received Text: " + text));
            }
            JmsSendReceiveTestSupport.assertEquals((String)("Message: " + i), (String)this.data[i], (String)text);
            JmsSendReceiveTestSupport.assertEquals((String)this.data[i], (String)stringProperty);
            JmsSendReceiveTestSupport.assertEquals((int)i, (int)intProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 30000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() < this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List<Message> messageList) {
        if (this.verbose && LOG.isDebugEnabled()) {
            LOG.info((Object)("Received message: " + message));
        }
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected List<Message> createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }

    protected void messageSent() throws Exception {
    }
}

