/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.amq.AMQPersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestSupport
extends CombinationTestSupport {
    protected ActiveMQConnectionFactory connectionFactory;
    protected boolean topic = true;
    public PersistenceAdapterChoice defaultPersistenceAdapter = PersistenceAdapterChoice.KahaDB;

    protected ActiveMQMessage createMessage() {
        return new ActiveMQMessage();
    }

    protected javax.jms.Destination createDestination(String subject) {
        if (this.topic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected javax.jms.Destination createDestination() {
        return this.createDestination(this.getDestinationString());
    }

    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName(true);
    }

    protected void assertTextMessagesEqual(String messsage, Message[] firstSet, Message[] secondSet) throws JMSException {
        TestSupport.assertEquals((String)("Message count does not match: " + messsage), (int)firstSet.length, (int)secondSet.length);
        for (int i = 0; i < secondSet.length; ++i) {
            TextMessage m1 = (TextMessage)firstSet[i];
            TextMessage m2 = (TextMessage)secondSet[i];
            TestSupport.assertFalse((String)("Message " + (i + 1) + " did not match : " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (boolean)(m1 == null ^ m2 == null));
            TestSupport.assertEquals((String)("Message " + (i + 1) + " did not match: " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (String)m1.getText(), (String)m2.getText());
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            TestSupport.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    protected String getConsumerSubject() {
        return this.getSubject();
    }

    protected String getProducerSubject() {
        return this.getSubject();
    }

    protected String getSubject() {
        return this.getName();
    }

    public static void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                TestSupport.recursiveDelete(files[i]);
            }
        }
        f.delete();
    }

    public static void removeMessageStore() {
        if (System.getProperty("activemq.store.dir") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("activemq.store.dir")));
        }
        if (System.getProperty("derby.system.home") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("derby.system.home")));
        }
    }

    public static DestinationStatistics getDestinationStatistics(BrokerService broker, ActiveMQDestination destination) {
        DestinationStatistics result = null;
        Destination dest = TestSupport.getDestination(broker, destination);
        if (dest != null) {
            result = dest.getDestinationStatistics();
        }
        return result;
    }

    public static Destination getDestination(BrokerService target, ActiveMQDestination destination) {
        Destination result = null;
        for (Destination dest : TestSupport.getDestinationMap(target, destination).values()) {
            if (!dest.getName().equals(destination.getPhysicalName())) continue;
            result = dest;
            break;
        }
        return result;
    }

    private static Map<ActiveMQDestination, Destination> getDestinationMap(BrokerService target, ActiveMQDestination destination) {
        RegionBroker regionBroker = (RegionBroker)target.getRegionBroker();
        return destination.isQueue() ? regionBroker.getQueueRegion().getDestinationMap() : regionBroker.getTopicRegion().getDestinationMap();
    }

    public PersistenceAdapter setDefaultPersistenceAdapter(BrokerService broker) throws IOException {
        return this.setPersistenceAdapter(broker, this.defaultPersistenceAdapter);
    }

    public PersistenceAdapter setPersistenceAdapter(BrokerService broker, PersistenceAdapterChoice choice) throws IOException {
        AMQPersistenceAdapter adapter = null;
        switch (choice) {
            case AMQ: {
                adapter = new AMQPersistenceAdapter();
                break;
            }
            case JDBC: {
                adapter = new JDBCPersistenceAdapter();
                break;
            }
            case KahaDB: {
                adapter = new KahaDBPersistenceAdapter();
                break;
            }
            case MEM: {
                adapter = new MemoryPersistenceAdapter();
            }
        }
        broker.setPersistenceAdapter(adapter);
        return adapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PersistenceAdapterChoice {
        KahaDB,
        AMQ,
        JDBC,
        MEM;

    }
}

