/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import junit.framework.Assert;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.advisory.TempQueueMemoryTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterSlaveTempQueueMemoryTest
extends TempQueueMemoryTest {
    private static final transient Log LOG = LogFactory.getLog(MasterSlaveTempQueueMemoryTest.class);
    String masterBindAddress = "tcp://localhost:61616";
    String slaveBindAddress = "tcp://localhost:62616";
    BrokerService slave;

    protected BrokerService createBroker() throws Exception {
        this.bindAddress = this.masterBindAddress;
        BrokerService master = super.createBroker();
        master.setBrokerName("master");
        this.configureBroker(master);
        this.bindAddress = this.slaveBindAddress;
        this.slave = super.createBroker();
        this.slave.setBrokerName("slave");
        this.slave.setMasterConnectorURI(this.masterBindAddress);
        this.configureBroker(this.slave);
        this.bindAddress = this.masterBindAddress;
        return master;
    }

    private void configureBroker(BrokerService broker) {
        broker.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setOptimizedDispatch(true);
        policyMap.setDefaultEntry(defaultEntry);
    }

    protected void startBroker() throws Exception {
        Thread starterThread = new Thread(){

            public void run() {
                try {
                    MasterSlaveTempQueueMemoryTest.this.broker.setWaitForSlave(true);
                    MasterSlaveTempQueueMemoryTest.this.broker.start();
                }
                catch (Exception e) {
                    Assert.fail((String)("failed to start broker, reason:" + e));
                    e.printStackTrace();
                }
            }
        };
        starterThread.start();
        this.slave.start();
        starterThread.join(60000L);
        MasterSlaveTempQueueMemoryTest.assertTrue((String)"slave is indeed a slave", (boolean)this.slave.isSlave());
    }

    protected void tearDown() throws Exception {
        this.slave.stop();
        super.tearDown();
    }

    public void testLoadRequestReply() throws Exception {
        super.testLoadRequestReply();
        Thread.sleep(2000L);
        AdvisoryBroker ab = (AdvisoryBroker)this.slave.getBroker().getAdaptor(AdvisoryBroker.class);
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"the temp queues should not be visible as they are removed", (int)1, (int)ab.getAdvisoryDestinations().size());
        RegionBroker rb = (RegionBroker)this.slave.getBroker().getAdaptor(RegionBroker.class);
        MasterSlaveTempQueueMemoryTest.assertEquals((int)6, (int)rb.getDestinationMap().size());
        RegionBroker masterRb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        LOG.info((Object)("enqueues " + rb.getDestinationStatistics().getEnqueues().getCount()));
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"enqueues match", (long)rb.getDestinationStatistics().getEnqueues().getCount(), (long)masterRb.getDestinationStatistics().getEnqueues().getCount());
        LOG.info((Object)("dequeues " + rb.getDestinationStatistics().getDequeues().getCount()));
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"dequeues match", (long)rb.getDestinationStatistics().getDequeues().getCount(), (long)masterRb.getDestinationStatistics().getDequeues().getCount());
        LOG.info((Object)("inflight, slave " + rb.getDestinationStatistics().getInflight().getCount() + ", master " + masterRb.getDestinationStatistics().getInflight().getCount()));
        MasterSlaveTempQueueMemoryTest.assertTrue((String)("dispatched to slave is as good as master, master=" + masterRb.getDestinationStatistics().getDispatched().getCount()), (rb.getDestinationStatistics().getDispatched().getCount() + (long)(2 * this.messagesToSend) >= masterRb.getDestinationStatistics().getDispatched().getCount() ? 1 : 0) != 0);
    }

    public void testMoreThanPageSizeUnacked() throws Exception {
        int messageCount = 210;
        final CountDownLatch latch = new CountDownLatch(1);
        this.serverSession = this.serverConnection.createSession(false, 1);
        ActiveMQSession s = (ActiveMQSession)this.serverSession;
        s.setSessionAsyncDispatch(true);
        MessageConsumer serverConsumer = this.serverSession.createConsumer(this.serverDestination);
        serverConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    latch.await(30L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        MessageProducer producer = this.clientSession.createProducer(this.serverDestination);
        for (int i = 0; i < 210; ++i) {
            Message msg = this.clientSession.createMessage();
            producer.send(msg);
        }
        Thread.sleep(5000L);
        RegionBroker slaveRb = (RegionBroker)this.slave.getBroker().getAdaptor(RegionBroker.class);
        RegionBroker masterRb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"inflight match expected", (long)210L, (long)masterRb.getDestinationStatistics().getInflight().getCount());
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"inflight match on slave and master", (long)slaveRb.getDestinationStatistics().getInflight().getCount(), (long)masterRb.getDestinationStatistics().getInflight().getCount());
        latch.countDown();
        Thread.sleep(5000L);
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"inflight match expected", (long)0L, (long)masterRb.getDestinationStatistics().getInflight().getCount());
        MasterSlaveTempQueueMemoryTest.assertEquals((String)"inflight match on slave and master", (long)slaveRb.getDestinationStatistics().getInflight().getCount(), (long)masterRb.getDestinationStatistics().getInflight().getCount());
    }

    public void testLoadRequestReplyWithNoTempQueueDelete() throws Exception {
        this.deleteTempQueue = false;
        this.messagesToSend = 10;
        this.testLoadRequestReply();
    }

    public void testLoadRequestReplyWithTransactions() throws Exception {
        this.clientTransactional = true;
        this.serverTransactional = true;
        this.messagesToSend = 100;
        this.reInitialiseSessions();
        this.testLoadRequestReply();
    }

    public void testConcurrentConsumerLoadRequestReplyWithTransactions() throws Exception {
        this.serverTransactional = true;
        this.numProducers = 10;
        this.numConsumers = 10;
        this.messagesToSend = 100;
        this.reInitialiseSessions();
        this.testLoadRequestReply();
    }

    protected void reInitialiseSessions() throws Exception {
        this.serverSession.close();
        this.clientSession.close();
        this.serverSession = this.serverConnection.createSession(this.serverTransactional, this.serverTransactional ? 0 : 1);
        this.clientSession = this.clientConnection.createSession(this.clientTransactional, this.clientTransactional ? 0 : 1);
    }
}

