/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ft.QueueMasterSlaveTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class JDBCQueueMasterSlaveTest
extends QueueMasterSlaveTest {
    protected EmbeddedDataSource sharedDs;
    protected String MASTER_URL = "tcp://localhost:62001";
    protected String SLAVE_URL = "tcp://localhost:62002";

    protected void setUp() throws Exception {
        this.sharedDs = (EmbeddedDataSource)new DataSourceSupport().getDataSource();
        super.setUp();
    }

    protected void createMaster() throws Exception {
        this.master = new BrokerService();
        this.master.addConnector(this.MASTER_URL);
        this.master.setUseJmx(false);
        this.master.setPersistent(true);
        this.master.setDeleteAllMessagesOnStartup(true);
        JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
        persistenceAdapter.setDataSource((DataSource)this.getExistingDataSource());
        persistenceAdapter.setLockKeepAlivePeriod(500L);
        persistenceAdapter.setLockAcquireSleepInterval(500L);
        this.master.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.master.start();
    }

    protected void createSlave() throws Exception {
        Thread t = new Thread(){

            public void run() {
                try {
                    BrokerService broker = new BrokerService();
                    broker.addConnector(JDBCQueueMasterSlaveTest.this.SLAVE_URL);
                    broker.setUseJmx(false);
                    broker.setPersistent(true);
                    JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
                    persistenceAdapter.setDataSource((DataSource)JDBCQueueMasterSlaveTest.this.getExistingDataSource());
                    persistenceAdapter.setCreateTablesOnStartup(false);
                    broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
                    broker.start();
                    JDBCQueueMasterSlaveTest.this.slave.set(broker);
                    JDBCQueueMasterSlaveTest.this.slaveStarted.countDown();
                }
                catch (Exception e) {
                    Assert.fail((String)("failed to start slave broker, reason:" + e));
                }
            }
        };
        t.start();
    }

    protected EmbeddedDataSource getExistingDataSource() throws Exception {
        return this.sharedDs;
    }
}

