/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import org.apache.activemq.ProducerFlowControlTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterSlaveProducerFlowControlTest
extends ProducerFlowControlTest {
    static final Log LOG = LogFactory.getLog(MasterSlaveProducerFlowControlTest.class);
    BrokerService slave;

    protected BrokerService createBroker() throws Exception {
        BrokerService service = super.createBroker();
        service.start();
        this.slave = new BrokerService();
        this.slave.setBrokerName("Slave");
        this.slave.setPersistent(false);
        this.slave.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new VMPendingSubscriberMessageStoragePolicy());
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        policy.setProducerFlowControl(true);
        policyMap.setDefaultEntry(policy);
        this.slave.setDestinationPolicy(policyMap);
        this.slave.setMasterConnectorURI(this.connector.getConnectUri().toString());
        this.slave.start();
        return service;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.slave != null) {
            this.slave.stop();
        }
    }
}

