/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.ArrayList;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.broker.region.policy.PriorityNetworkDispatchPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.usage.SystemUsage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PriorityNetworkDispatchPolicyTest {
    PriorityNetworkDispatchPolicy underTest = new PriorityNetworkDispatchPolicy();
    SystemUsage usageManager = new SystemUsage();
    ConsumerInfo info = new ConsumerInfo();
    ActiveMQMessage node = new ActiveMQMessage();
    ConsumerId id = new ConsumerId();
    ConnectionContext context = new ConnectionContext();

    @Before
    public void init() throws Exception {
        this.info.setDestination(ActiveMQDestination.createDestination((String)"test", (byte)2));
        this.info.setConsumerId(this.id);
        this.info.setNetworkSubscription(true);
        this.info.setNetworkConsumerPath(new ConsumerId[]{this.id});
    }

    @Test
    public void testRemoveLowerPriorityDup() throws Exception {
        ArrayList<TopicSubscription> consumers = new ArrayList<TopicSubscription>();
        for (int i = 0; i < 3; ++i) {
            ConsumerInfo instance = this.info.copy();
            instance.setPriority((byte)i);
            consumers.add(new TopicSubscription(null, this.context, instance, this.usageManager));
        }
        this.underTest.dispatch((MessageReference)this.node, null, consumers);
        long count = 0L;
        for (Subscription subscription : consumers) {
            count += subscription.getEnqueueCounter();
        }
        Assert.assertEquals((String)"only one sub got message", (long)1L, (long)count);
    }
}

