/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.store;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.store.amq.AMQTransactionStore;
import org.apache.activemq.store.amq.AMQTx;

public class TransactionStoreTest
extends TestCase {
    protected static final int MAX_TX = 2500;
    protected static final int MAX_THREADS = 200;
    BeingTested underTest = new BeingTested();

    public void testConcurrentGetTx() throws Exception {
        final ConnectionId connectionId = new ConnectionId("1:1");
        Runnable getTx = new Runnable(){

            public void run() {
                for (int i = 0; i < 2500; ++i) {
                    LocalTransactionId txid = new LocalTransactionId(connectionId, (long)i);
                    TransactionStoreTest.this.underTest.getTx((TransactionId)txid, null);
                }
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(200);
        for (int i = 0; i < 200; ++i) {
            executor.execute(getTx);
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        TransactionStoreTest.assertEquals((String)"has just the right amount of transactions", (int)2500, (int)this.underTest.getInFlight().size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BeingTested
    extends AMQTransactionStore {
        public BeingTested() {
            super(null);
        }

        public Map<TransactionId, AMQTx> getInFlight() {
            return this.inflightTransactions;
        }
    }
}

