/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginBrokerTest
extends JmsTopicSendReceiveTest {
    private static final Log LOG = LogFactory.getLog(PluginBrokerTest.class);
    private BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/util/plugin-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info((Object)("Loading broker configuration from the classpath with URI: " + uri));
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    protected void assertMessageValid(int index, Message message) throws JMSException {
        PluginBrokerTest.assertEquals((String)"localhost", (String)message.getStringProperty("BrokerPath"));
        ActiveMQMessage amqMsg = (ActiveMQMessage)message;
        if (index == 7) {
            PluginBrokerTest.assertTrue((String)"expiration is in range, depends on two distinct calls to System.currentTimeMillis", (1500L < amqMsg.getExpiration() - amqMsg.getTimestamp() ? 1 : 0) != 0);
        } else if (index == 9) {
            PluginBrokerTest.assertTrue((String)"expiration ceeling is in range, depends on two distinct calls to System.currentTimeMillis", (59500L < amqMsg.getExpiration() - amqMsg.getTimestamp() ? 1 : 0) != 0);
        } else {
            PluginBrokerTest.assertEquals((long)1000L, (long)(amqMsg.getExpiration() - amqMsg.getTimestamp()));
        }
        super.assertMessageValid(index, message);
    }

    protected void sendMessage(int index, Message message) throws Exception {
        if (index == 7) {
            this.producer.send(this.producerDestination, message, 2, 4, 2000L);
        } else if (index == 9) {
            this.producer.send(this.producerDestination, message, 2, 4, 200000L);
        } else {
            super.sendMessage(index, message);
        }
    }
}

