/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQ2021Test
extends TestCase
implements ExceptionListener,
Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(AMQ2021Test.class);
    BrokerService brokerService;
    ArrayList<Thread> threads = new ArrayList();
    Vector<Throwable> exceptions;
    AMQ2021Test testCase;
    String ACTIVEMQ_BROKER_BIND = "tcp://localhost:61616";
    String ACTIVEMQ_BROKER_URL = this.ACTIVEMQ_BROKER_BIND + "?jms.redeliveryPolicy.maximumRedeliveries=1&jms.redeliveryPolicy.initialRedeliveryDelay=0";
    private int numMessages = 1000;
    private int numConsumers = 2;
    private int dlqMessages = this.numMessages / 2;
    CountDownLatch receivedLatch;
    private ActiveMQTopic destination;
    public CountDownLatch started;

    protected void setUp() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.testCase = this;
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.addConnector(this.ACTIVEMQ_BROKER_BIND);
        this.brokerService.start();
        this.destination = new ActiveMQTopic(this.getName());
        this.exceptions = new Vector();
        this.receivedLatch = new CountDownLatch(this.numConsumers * (this.numMessages + this.dlqMessages));
        this.started = new CountDownLatch(1);
    }

    protected void tearDown() throws Exception {
        for (Thread t : this.threads) {
            t.interrupt();
            t.join();
        }
        this.brokerService.stop();
    }

    public void testConcurrentTopicResendToDLQ() throws Exception {
        for (int i = 0; i < this.numConsumers; ++i) {
            ConsumerThread c1 = new ConsumerThread("Consumer-" + i);
            this.threads.add(c1);
            c1.start();
        }
        AMQ2021Test.assertTrue((boolean)this.started.await(10L, TimeUnit.SECONDS));
        Thread producer = new Thread(){

            public void run() {
                try {
                    AMQ2021Test.this.produce(AMQ2021Test.this.numMessages);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.threads.add(producer);
        producer.start();
        boolean allGood = this.receivedLatch.await(30L, TimeUnit.SECONDS);
        for (Throwable t : this.exceptions) {
            log.error((Object)"failing test with first exception", t);
            AMQ2021Test.fail((String)("exception during test : " + t));
        }
        AMQ2021Test.assertTrue((String)"excepted messages received within time limit", (boolean)allGood);
        AMQ2021Test.assertEquals((int)0, (int)this.exceptions.size());
        for (int i = 0; i < this.numConsumers; ++i) {
            AMQ2021Test.assertEquals((long)(this.dlqMessages * 2), (long)((ConsumerThread)this.threads.get((int)i)).recoveries);
            AMQ2021Test.assertEquals((long)(this.numMessages + this.dlqMessages), (long)((ConsumerThread)this.threads.get((int)i)).counter);
        }
        this.consumeFromDLQ(this.dlqMessages);
    }

    private void consumeFromDLQ(int messageCount) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.ACTIVEMQ_BROKER_URL);
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        int count = 0;
        for (int i = 0; i < messageCount && dlqConsumer.receive(1000L) != null; ++i) {
            ++count;
        }
        AMQ2021Test.assertEquals((int)messageCount, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(int count) throws Exception {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.ACTIVEMQ_BROKER_BIND);
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)this.destination);
            producer.setTimeToLive(0L);
            connection.start();
            for (int i = 0; i < count; ++i) {
                int id = i + 1;
                TextMessage message = session.createTextMessage(this.getName() + " Message " + id);
                message.setIntProperty("MsgNumber", id);
                producer.send((Message)message);
                if (id % 500 != 0) continue;
                log.info((Object)("sent " + id + ", ith " + message));
            }
        }
        catch (JMSException e) {
            log.error((Object)"unexpected ex on produce", (Throwable)e);
            this.exceptions.add(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void onException(JMSException exception) {
        log.info((Object)"Unexpected JMSException", (Throwable)exception);
        this.exceptions.add(exception);
    }

    public void uncaughtException(Thread thread, Throwable exception) {
        log.info((Object)("Unexpected exception from thread " + thread + ", ex: " + exception));
        this.exceptions.add(exception);
    }

    public class ConsumerThread
    extends Thread
    implements MessageListener {
        public long counter;
        public long recoveries;
        private Session session;

        public ConsumerThread(String threadId) {
            super(threadId);
            this.counter = 0L;
            this.recoveries = 0L;
        }

        public void run() {
            try {
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(AMQ2021Test.this.ACTIVEMQ_BROKER_URL);
                Connection connection = connectionFactory.createConnection();
                connection.setExceptionListener((ExceptionListener)AMQ2021Test.this.testCase);
                connection.setClientID(this.getName());
                this.session = connection.createSession(false, 2);
                TopicSubscriber consumer = this.session.createDurableSubscriber((Topic)AMQ2021Test.this.destination, this.getName());
                consumer.setMessageListener((MessageListener)this);
                connection.start();
                AMQ2021Test.this.started.countDown();
            }
            catch (JMSException exception) {
                log.error((Object)"unexpected ex in consumer run", (Throwable)exception);
                AMQ2021Test.this.exceptions.add(exception);
            }
        }

        public void onMessage(Message message) {
            try {
                ++this.counter;
                int messageNumber = message.getIntProperty("MsgNumber");
                if (messageNumber % 2 == 0) {
                    this.session.recover();
                    ++this.recoveries;
                } else {
                    message.acknowledge();
                }
                if (this.counter % 200L == 0L) {
                    log.info((Object)("recoveries:" + this.recoveries + ", Received " + this.counter + ", counter'th " + message));
                }
                AMQ2021Test.this.receivedLatch.countDown();
            }
            catch (Exception e) {
                log.error((Object)"unexpected ex on onMessage", (Throwable)e);
                AMQ2021Test.this.exceptions.add(e);
            }
        }
    }
}

