/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.IntHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQ2102Test
extends CombinationTestSupport
implements Thread.UncaughtExceptionHandler {
    static final int MESSAGE_COUNT = 12120;
    static final int NUM_CONSUMERS = 10;
    static final int CONSUME_ALL = -1;
    private static final Log LOG = LogFactory.getLog(AMQ2102Test.class);
    private static final Map<Thread, Throwable> exceptions = new ConcurrentHashMap<Thread, Throwable>();
    final BrokerService master = new BrokerService();
    BrokerService slave = new BrokerService();
    String masterUrl;

    private static void debug(String message) {
        LOG.info((Object)message);
    }

    private static void info(String message) {
        LOG.info((Object)message);
    }

    private static void error(String message) {
        LOG.error((Object)message);
    }

    private static void error(String message, Throwable t) {
        t.printStackTrace();
        String msg = message + ": " + (t.getMessage() != null ? t.getMessage() : t.toString());
        LOG.error((Object)msg, t);
        exceptions.put(Thread.currentThread(), t);
        AMQ2102Test.fail((String)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Consumer> createConsumers(ActiveMQConnectionFactory connectionFactory, String queueName, int max, int numToProcessPerConsumer) {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>(max);
        IntHolder startup = new IntHolder(max);
        for (int id = 0; id < max; ++id) {
            consumers.add(new Consumer(connectionFactory, queueName, startup, id, numToProcessPerConsumer));
        }
        for (Consumer consumer : consumers) {
            consumer.start();
        }
        IntHolder intHolder = startup;
        synchronized (intHolder) {
            while (startup.value > 0) {
                try {
                    startup.wait();
                }
                catch (InterruptedException e) {
                    AMQ2102Test.error("Interrupted waiting for consumers to start", e);
                }
            }
        }
        return consumers;
    }

    @Override
    public void setUp() throws Exception {
        this.setMaxTestTime(720000L);
        this.setAutoFail(true);
        super.setUp();
        this.master.setUseShutdownHook(false);
        this.master.setBrokerName("Master");
        this.master.addConnector("tcp://localhost:0");
        this.master.deleteAllMessages();
        this.master.setWaitForSlave(true);
        Thread t = new Thread(){

            public void run() {
                try {
                    AMQ2102Test.this.master.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.put(Thread.currentThread(), e);
                }
            }
        };
        t.start();
        this.masterUrl = ((TransportConnector)this.master.getTransportConnectors().get(0)).getConnectUri().toString();
        AMQ2102Test.debug("masterUrl: " + this.masterUrl);
        this.slave.setUseShutdownHook(false);
        this.slave.setBrokerName("Slave");
        this.slave.deleteAllMessages();
        this.slave.addConnector("tcp://localhost:0");
        this.slave.setMasterConnectorURI(this.masterUrl);
        this.slave.start();
        this.slave.waitUntilStarted();
        AMQ2102Test.assertTrue((String)"master started", (boolean)this.master.waitUntilStarted());
    }

    @Override
    public void tearDown() throws Exception {
        this.master.stop();
        this.slave.stop();
        exceptions.clear();
    }

    public void testMasterSlaveBug() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + this.masterUrl + ")?randomize=false");
        String queueName = "MasterSlaveBug";
        ArrayList<Consumer> consumers = this.createConsumers(connectionFactory, queueName, 10, -1);
        Producer producer = new Producer(connectionFactory, queueName);
        producer.execute(new String[0]);
        for (Consumer consumer : consumers) {
            consumer.setRunning(false);
        }
        for (Consumer consumer : consumers) {
            consumer.join();
        }
        AMQ2102Test.assertTrue((boolean)exceptions.isEmpty());
    }

    public void testMasterSlaveBugWithStopStartConsumers() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this);
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + this.masterUrl + ")?randomize=false");
        String queueName = "MasterSlaveBug";
        ArrayList<Consumer> consumers = this.createConsumers(connectionFactory, queueName, 10, 10);
        Producer producer = new Producer(connectionFactory, queueName);
        producer.execute(new String[0]);
        for (Consumer consumer : consumers) {
            consumer.setRunning(false);
        }
        for (Consumer consumer : consumers) {
            consumer.join();
        }
        AMQ2102Test.assertTrue((boolean)exceptions.isEmpty());
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        AMQ2102Test.error("" + t + e);
        exceptions.put(t, e);
    }

    private class Producer
    implements ExceptionListener {
        private ActiveMQConnectionFactory connectionFactory;
        private String queueName;

        Producer(ActiveMQConnectionFactory connectionFactory, String queueName) {
            this.connectionFactory = connectionFactory;
            this.queueName = queueName;
        }

        void execute(String[] args) {
            try {
                this.sendMessages();
            }
            catch (Exception e) {
                AMQ2102Test.error("Producer failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages() throws JMSException {
            ActiveMQConnection connection = null;
            try {
                connection = (ActiveMQConnection)this.connectionFactory.createConnection();
                connection.setExceptionListener((ExceptionListener)this);
                connection.start();
                this.sendMessages(connection);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {
                        AMQ2102Test.error("Problem closing connection", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages(ActiveMQConnection connection) throws JMSException {
            Session session = null;
            try {
                session = connection.createSession(true, 1);
                this.sendMessages(session);
            }
            catch (JMSException e) {
                e.printStackTrace();
                exceptions.put(Thread.currentThread(), e);
                if (session != null) {
                    session.rollback();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages(Session session) throws JMSException {
            TemporaryQueue replyQueue = null;
            try {
                replyQueue = session.createTemporaryQueue();
                this.sendMessages(session, (Destination)replyQueue);
            }
            finally {
                if (replyQueue != null) {
                    replyQueue.delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages(Session session, Destination replyQueue) throws JMSException {
            MessageConsumer consumer = null;
            try {
                consumer = session.createConsumer(replyQueue);
                this.sendMessages(session, replyQueue, consumer);
            }
            finally {
                consumer.close();
                session.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages(Session session, Destination replyQueue, int messageCount) throws JMSException {
            MessageProducer producer = null;
            try {
                producer = session.createProducer((Destination)session.createQueue(this.queueName));
                producer.setDeliveryMode(2);
                producer.setTimeToLive(0L);
                producer.setPriority(4);
                for (int i = 0; i < messageCount; ++i) {
                    TextMessage message = session.createTextMessage("message#" + i);
                    message.setJMSReplyTo(replyQueue);
                    producer.send((Message)message);
                }
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessages(final Session session, Destination replyQueue, MessageConsumer consumer) throws JMSException {
            final IntHolder messageCount = new IntHolder(12120);
            consumer.setMessageListener(new MessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Message reply) {
                    if (reply instanceof TextMessage) {
                        TextMessage textReply = (TextMessage)reply;
                        IntHolder intHolder = messageCount;
                        synchronized (intHolder) {
                            try {
                                AMQ2102Test.debug("receive reply#" + messageCount.value + " " + textReply.getText() + ", " + textReply.getJMSMessageID());
                            }
                            catch (JMSException e) {
                                AMQ2102Test.error("Problem processing reply", e);
                            }
                            --messageCount.value;
                            if (messageCount.value % 200 == 0) {
                                AMQ2102Test.info("acking via session commit: messageCount=" + messageCount.value);
                                try {
                                    session.commit();
                                }
                                catch (JMSException e) {
                                    AMQ2102Test.error("Failed to commit with count: " + messageCount.value, e);
                                }
                            }
                            messageCount.notifyAll();
                        }
                    }
                    AMQ2102Test.error("Producer cannot process " + reply.getClass().getSimpleName());
                }
            });
            this.sendMessages(session, replyQueue, messageCount.value);
            session.commit();
            IntHolder intHolder = messageCount;
            synchronized (intHolder) {
                while (messageCount.value > 0) {
                    try {
                        messageCount.wait();
                    }
                    catch (InterruptedException e) {
                        AMQ2102Test.error("Interrupted waiting for replies", e);
                    }
                }
            }
            session.commit();
            AMQ2102Test.debug("All replies received...");
        }

        public void onException(JMSException exception) {
            LOG.error((Object)exception);
            exceptions.put(Thread.currentThread(), exception);
        }
    }

    private class Consumer
    implements Runnable,
    ExceptionListener {
        private ActiveMQConnectionFactory connectionFactory;
        private String name;
        private String queueName;
        private boolean running;
        private IntHolder startup;
        private Thread thread;
        private final int numToProcessPerIteration;

        Consumer(ActiveMQConnectionFactory connectionFactory, String queueName, IntHolder startup, int id, int numToProcess) {
            this.connectionFactory = connectionFactory;
            this.queueName = queueName;
            this.startup = startup;
            this.name = "Consumer-" + queueName + "-" + id;
            this.numToProcessPerIteration = numToProcess;
            this.thread = new Thread((Runnable)this, this.name);
        }

        private String getClientId() {
            try {
                return InetAddress.getLocalHost().getHostName() + ":" + this.name;
            }
            catch (UnknownHostException e) {
                return "localhost:" + this.name;
            }
        }

        synchronized boolean isRunning() {
            return this.running;
        }

        void join() {
            try {
                this.thread.join(30000L);
            }
            catch (InterruptedException e) {
                AMQ2102Test.error("Interrupted waiting for " + this.name + " to stop", e);
            }
        }

        public void onException(JMSException e) {
            exceptions.put(Thread.currentThread(), e);
            AMQ2102Test.error("JMS exception: ", e);
        }

        private void processMessage(Session session, MessageProducer producer, Message message) throws Exception {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                Destination replyQueue = textMessage.getJMSReplyTo();
                if (replyQueue != null) {
                    TextMessage reply = session.createTextMessage("reply-" + textMessage.getText());
                    reply.setJMSCorrelationID(textMessage.getJMSCorrelationID());
                    producer.send(replyQueue, (Message)reply);
                    AMQ2102Test.debug("replied via " + replyQueue + " for message => " + textMessage.getText() + ", " + textMessage.getJMSMessageID());
                } else {
                    AMQ2102Test.debug("no reply to message => " + textMessage.getText() + ", " + textMessage.getJMSMessageID());
                }
            } else {
                AMQ2102Test.error("Consumer cannot process " + message.getClass().getSimpleName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessages() throws JMSException {
            ActiveMQConnection connection = null;
            try {
                connection = (ActiveMQConnection)this.connectionFactory.createConnection();
                RedeliveryPolicy policy = connection.getRedeliveryPolicy();
                policy.setMaximumRedeliveries(6);
                policy.setInitialRedeliveryDelay(1000L);
                policy.setUseCollisionAvoidance(false);
                policy.setCollisionAvoidancePercent((short)15);
                policy.setUseExponentialBackOff(false);
                policy.setBackOffMultiplier(5.0);
                connection.setClientID(this.getClientId());
                connection.setExceptionListener((ExceptionListener)this);
                connection.start();
                this.processMessages((Connection)connection);
            }
            finally {
                connection.close();
                connection = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessages(Connection connection) throws JMSException {
            Session session = null;
            try {
                session = connection.createSession(true, 0);
                if (this.numToProcessPerIteration > 0) {
                    while (this.isRunning()) {
                        this.processMessages(session);
                    }
                } else {
                    this.processMessages(session);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessages(Session session) throws JMSException {
            MessageConsumer consumer = null;
            try {
                consumer = session.createConsumer((Destination)session.createQueue(this.queueName), null);
                this.processMessages(session, consumer);
            }
            finally {
                if (consumer != null) {
                    consumer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessages(Session session, MessageConsumer consumer) throws JMSException {
            MessageProducer producer = null;
            try {
                producer = session.createProducer(null);
                producer.setDeliveryMode(1);
                this.processMessages(session, consumer, producer);
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessages(Session session, MessageConsumer consumer, MessageProducer producer) throws JMSException {
            AMQ2102Test.debug("waiting for messages...");
            if (this.startup != null) {
                IntHolder intHolder = this.startup;
                synchronized (intHolder) {
                    --this.startup.value;
                    this.startup.notify();
                }
                this.startup = null;
            }
            int numToProcess = this.numToProcessPerIteration;
            do {
                Message message;
                if ((message = consumer.receive(5000L)) != null) {
                    try {
                        this.processMessage(session, producer, message);
                        session.commit();
                        --numToProcess;
                    }
                    catch (Throwable t) {
                        AMQ2102Test.error("message=" + message + " failure", t);
                        session.rollback();
                    }
                    continue;
                }
                AMQ2102Test.info("got null message on: " + numToProcess);
            } while ((this.numToProcessPerIteration == -1 || numToProcess > 0) && this.isRunning());
        }

        public void run() {
            this.setRunning(true);
            while (this.isRunning()) {
                try {
                    this.processMessages();
                }
                catch (Throwable t) {
                    AMQ2102Test.error("Unexpected consumer problem: ", t);
                }
            }
        }

        synchronized void setRunning(boolean running) {
            this.running = running;
        }

        void start() {
            this.thread.start();
        }
    }
}

