/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;

public class AMQ2401Test
extends TestCase
implements MessageListener {
    BrokerService broker;
    private ActiveMQConnectionFactory factory;
    private static final int SEND_COUNT = 500;
    private static final int CONSUMER_COUNT = 50;
    private static final int PRODUCER_COUNT = 1;
    private static final int LOG_INTERVAL = 10;
    private ArrayList<Service> services = new ArrayList(51);
    int count = 0;
    CountDownLatch latch;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "test-data" + File.separator + "AMQ2401Test");
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.addConnector("tcp://0.0.0.0:2401");
        PolicyMap policies = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setMemoryLimit(102400L);
        entry.setProducerFlowControl(true);
        entry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        entry.setQueue(">");
        policies.setDefaultEntry(entry);
        this.broker.setDestinationPolicy(policies);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory("tcp://0.0.0.0:2401");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDupsOk() throws Exception {
        TestProducer p = null;
        TestConsumer c = null;
        try {
            int i;
            this.latch = new CountDownLatch(500);
            for (i = 0; i < 50; ++i) {
                TestConsumer consumer = new TestConsumer();
                consumer.start();
                this.services.add(consumer);
            }
            for (i = 0; i < 1; ++i) {
                TestProducer producer = new TestProducer();
                producer.start();
                this.services.add(producer);
            }
            this.waitForMessageReceipt(3000L);
        }
        finally {
            if (p != null) {
                p.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public void onMessage(Message message) {
        this.latch.countDown();
        if (++this.count % 10 == 0) {
            System.out.println("Received message " + this.count);
        }
        try {
            Thread.currentThread();
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void waitForMessageReceipt(long timeout) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Consumner didn't receive messages");
        }
    }

    private class TestConsumer
    implements Runnable,
    Service {
        ActiveMQConnection connection;
        Session session;
        MessageConsumer consumer;
        Thread thread;

        TestConsumer() throws Exception {
            AMQ2401Test.this.factory.setOptimizeAcknowledge(false);
            this.connection = (ActiveMQConnection)AMQ2401Test.this.factory.createConnection();
            this.session = this.connection.createSession(false, 3);
            this.consumer = this.session.createConsumer((Destination)this.session.createQueue("AMQ2401Test"));
            this.consumer.setMessageListener((MessageListener)AMQ2401Test.this);
        }

        public void start() throws Exception {
            this.connection.start();
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        public void run() {
            while (AMQ2401Test.this.latch.getCount() > 0L) {
                try {
                    AMQ2401Test.this.onMessage(this.consumer.receive());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class TestProducer
    implements Runnable,
    Service {
        Thread thread = new Thread((Runnable)this, "TestProducer");
        BytesMessage message;
        Connection connection;
        Session session;
        MessageProducer producer;

        TestProducer() throws Exception {
            this.connection = AMQ2401Test.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 3);
            this.producer = this.session.createProducer((Destination)this.session.createQueue("AMQ2401Test"));
        }

        public void start() {
            this.thread.start();
        }

        public void run() {
            int count = 500;
            for (int i = 1; i <= count; ++i) {
                try {
                    if (i % 10 == 0) {
                        System.out.println("Sending: " + i);
                    }
                    this.message = this.session.createBytesMessage();
                    this.message.writeBytes(new byte[1024]);
                    this.producer.send((Message)this.message);
                    continue;
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                    break;
                }
            }
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private static interface Service {
        public void start() throws Exception;

        public void close();
    }
}

