/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.IOHelper;

public class AMQ2512Test
extends EmbeddedBrokerTestSupport {
    private static Connection connection;
    private static final String QUEUE_NAME = "dee.q";
    private static final int INITIAL_MESSAGES_CNT = 1000;
    private static final int WORKER_INTERNAL_ITERATIONS = 100;
    private static final int TOTAL_MESSAGES_CNT = 101000;
    private static final byte[] payload;
    private static final String TEXT;
    private static final String PRP_INITIAL_ID = "initial-id";
    private static final String PRP_WORKER_ID = "worker-id";
    private static final CountDownLatch LATCH;
    private static final AtomicInteger ON_MSG_COUNTER;

    public void testKahaDBFailure() throws Exception {
        int i;
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(this.bindAddress);
        connection = fac.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        connection.start();
        long startTime = System.nanoTime();
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (i = 0; i < 20; ++i) {
            consumers.add(new Consumer("worker-" + i));
        }
        for (i = 0; i < 1000; ++i) {
            TextMessage msg = session.createTextMessage(TEXT);
            msg.setStringProperty(PRP_INITIAL_ID, "initial-" + i);
            producer.send((Message)msg);
        }
        LATCH.await();
        long endTime = System.nanoTime();
        System.out.println("Total execution time = " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " [ms].");
        System.out.println("Rate = " + 101000L / TimeUnit.SECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " [msg/s].");
        for (Consumer c : consumers) {
            c.close();
        }
        connection.close();
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://0.0.0.0:61617";
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        File dataFileDir = new File("target/test-amq-2512/datadb");
        IOHelper.mkdirs((File)dataFileDir);
        IOHelper.deleteChildren((File)dataFileDir);
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        BrokerService answer = new BrokerService();
        answer.setPersistenceAdapter((PersistenceAdapter)kaha);
        kaha.setEnableJournalDiskSyncs(false);
        answer.setDataDirectoryFile(dataFileDir);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    static {
        payload = new byte[5120];
        TEXT = new String(payload);
        LATCH = new CountDownLatch(101000);
        ON_MSG_COUNTER = new AtomicInteger();
    }

    private static final class Consumer
    implements MessageListener {
        private final String name;
        private final Session session;
        private final MessageProducer producer;

        private Consumer(String name) {
            this.name = name;
            try {
                this.session = connection.createSession(false, 2);
                Queue queue = this.session.createQueue("dee.q?consumer.prefetchSize=10");
                this.producer = this.session.createProducer((Destination)queue);
                this.producer.setDeliveryMode(2);
                MessageConsumer consumer = this.session.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public void onMessage(Message message) {
            TextMessage msg = (TextMessage)message;
            try {
                if (!msg.propertyExists(AMQ2512Test.PRP_WORKER_ID)) {
                    for (int i = 0; i < 100; ++i) {
                        TextMessage newMsg = this.session.createTextMessage(msg.getText());
                        newMsg.setStringProperty(AMQ2512Test.PRP_WORKER_ID, this.name + "-" + i);
                        newMsg.setStringProperty(AMQ2512Test.PRP_INITIAL_ID, msg.getStringProperty(AMQ2512Test.PRP_INITIAL_ID));
                        this.producer.send((Message)newMsg);
                    }
                }
                msg.acknowledge();
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                int onMsgCounter = ON_MSG_COUNTER.getAndIncrement();
                if (onMsgCounter % 1000 == 0) {
                    System.out.println("message received: " + onMsgCounter);
                }
                LATCH.countDown();
            }
        }

        private void close() {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

