/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQ2584Test
extends TestSupport {
    static final Log LOG = LogFactory.getLog(AMQ2584Test.class);
    BrokerService broker = null;
    ActiveMQTopic topic;
    ActiveMQConnection consumerConnection = null;
    ActiveMQConnection producerConnection = null;
    Session producerSession;
    MessageProducer producer;
    final int minPercentUsageForStore = 10;
    String data;

    public static Test suite() {
        return AMQ2584Test.suite(AMQ2584Test.class);
    }

    public void initCombosForTestSize() throws Exception {
        this.addCombinationValues("defaultPersistenceAdapter", new Object[]{TestSupport.PersistenceAdapterChoice.AMQ, TestSupport.PersistenceAdapterChoice.KahaDB});
    }

    public void testSize() throws Exception {
        CountDownLatch redeliveryConsumerLatch = new CountDownLatch(14999);
        this.openConsumer(redeliveryConsumerLatch);
        AMQ2584Test.assertEquals((int)0, (int)this.broker.getAdminView().getStorePercentUsage());
        for (int i = 0; i < 5000; ++i) {
            this.sendMessage(false);
        }
        final BrokerView brokerView = this.broker.getAdminView();
        this.broker.getSystemUsage().getStoreUsage().isFull();
        LOG.info((Object)("store percent usage: " + brokerView.getStorePercentUsage()));
        AMQ2584Test.assertTrue((String)"some store in use", (this.broker.getAdminView().getStorePercentUsage() > 10 ? 1 : 0) != 0);
        AMQ2584Test.assertTrue((String)"redelivery consumer got all it needs", (boolean)redeliveryConsumerLatch.await(60L, TimeUnit.SECONDS));
        this.closeConsumer();
        final CountDownLatch received = new CountDownLatch(4999);
        this.consumerConnection = (ActiveMQConnection)this.createConnection();
        Session dlqSession = this.consumerConnection.createSession(false, 1);
        MessageConsumer dlqConsumer = dlqSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        dlqConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                if (received.getCount() % 500L == 0L) {
                    LOG.info((Object)("remaining on DLQ: " + received.getCount()));
                }
                received.countDown();
            }
        });
        this.consumerConnection.start();
        AMQ2584Test.assertTrue((String)"Not all messages reached the DLQ", (boolean)received.await(60L, TimeUnit.SECONDS));
        AMQ2584Test.assertTrue((String)"Store usage exceeds expected usage", (boolean)Wait.waitFor(new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                AMQ2584Test.this.broker.getSystemUsage().getStoreUsage().isFull();
                LOG.info((Object)("store precent usage: " + brokerView.getStorePercentUsage()));
                return AMQ2584Test.this.broker.getAdminView().getStorePercentUsage() < 10;
            }
        }));
        this.closeConsumer();
    }

    private void openConsumer(final CountDownLatch latch) throws Exception {
        this.consumerConnection = (ActiveMQConnection)this.createConnection();
        this.consumerConnection.setClientID("cliID");
        this.consumerConnection.start();
        final Session session = this.consumerConnection.createSession(false, 1);
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
                try {
                    session.recover();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        };
        session.createDurableSubscriber((Topic)this.topic, "subName1").setMessageListener(listener);
        session.createDurableSubscriber((Topic)this.topic, "subName2").setMessageListener(listener);
        session.createDurableSubscriber((Topic)this.topic, "subName3").setMessageListener(listener);
    }

    private void closeConsumer() throws JMSException {
        if (this.consumerConnection != null) {
            this.consumerConnection.close();
        }
        this.consumerConnection = null;
    }

    private void sendMessage(boolean filter) throws Exception {
        if (this.producerConnection == null) {
            this.producerConnection = (ActiveMQConnection)this.createConnection();
            this.producerConnection.start();
            this.producerSession = this.producerConnection.createSession(false, 1);
            this.producer = this.producerSession.createProducer((Destination)this.topic);
        }
        Message message = this.producerSession.createMessage();
        message.setStringProperty("data", this.data);
        this.producer.send(message);
    }

    private void startBroker(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        this.broker.setAdvisorySupport(false);
        this.broker.setBrokerName("testStoreSize");
        if (deleteMessages) {
            this.broker.setDeleteAllMessagesOnStartup(true);
        }
        this.setDefaultPersistenceAdapter(this.broker);
        this.configurePersistenceAdapter(this.broker.getPersistenceAdapter());
        this.broker.getSystemUsage().getStoreUsage().setLimit(200000000L);
        this.broker.start();
    }

    private void configurePersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        Properties properties = new Properties();
        String maxFileLengthVal = String.valueOf(0x100000);
        properties.put("journalMaxFileLength", maxFileLengthVal);
        properties.put("maxFileLength", maxFileLengthVal);
        properties.put("cleanupInterval", "2000");
        properties.put("checkpointInterval", "2000");
        IntrospectionSupport.setProperties((Object)persistenceAdapter, (Map)properties);
    }

    private void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
        this.broker = null;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://testStoreSize?jms.watchTopicAdvisories=false&jms.redeliveryPolicy.maximumRedeliveries=0&waitForStart=5000&create=false");
    }

    protected void setUp() throws Exception {
        super.setUp();
        StringBuilder sb = new StringBuilder(5000);
        for (int i = 0; i < 5000; ++i) {
            sb.append('a');
        }
        this.data = sb.toString();
        this.startBroker(true);
        this.topic = (ActiveMQTopic)this.createDestination();
    }

    protected void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }
}

