/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.IOHelper;

public class AMQ2616Test
extends TestCase {
    private static final int NUMBER = 2000;
    private BrokerService brokerService;
    private final ArrayList<Thread> threads = new ArrayList();
    String ACTIVEMQ_BROKER_BIND = "tcp://0.0.0.0:61616";
    AtomicBoolean shutdown = new AtomicBoolean();

    public void testQueueResourcesReleased() throws Exception {
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(this.ACTIVEMQ_BROKER_BIND);
        Connection tempConnection = fac.createConnection();
        tempConnection.start();
        Session tempSession = tempConnection.createSession(false, 1);
        TemporaryQueue tempQueue = tempSession.createTemporaryQueue();
        MessageConsumer tempConsumer = tempSession.createConsumer((Destination)tempQueue);
        Connection testConnection = fac.createConnection();
        long startUsage = this.brokerService.getSystemUsage().getMemoryUsage().getUsage();
        Session testSession = testConnection.createSession(false, 1);
        MessageProducer testProducer = testSession.createProducer((Destination)tempQueue);
        byte[] payload = new byte[4096];
        for (int i = 0; i < 2000; ++i) {
            BytesMessage msg = testSession.createBytesMessage();
            msg.writeBytes(payload);
            testProducer.send((Message)msg);
        }
        long endUsage = this.brokerService.getSystemUsage().getMemoryUsage().getUsage();
        AMQ2616Test.assertFalse((startUsage == endUsage ? 1 : 0) != 0);
        tempConnection.close();
        Thread.sleep(1000L);
        endUsage = this.brokerService.getSystemUsage().getMemoryUsage().getUsage();
        AMQ2616Test.assertEquals((long)startUsage, (long)endUsage);
    }

    protected void setUp() throws Exception {
        this.brokerService = new BrokerService();
        KahaDBPersistenceAdapter adaptor = new KahaDBPersistenceAdapter();
        adaptor.setEnableJournalDiskSyncs(false);
        File file = new File("target/AMQ2616Test");
        IOHelper.mkdirs((File)file);
        IOHelper.deleteChildren((File)file);
        adaptor.setDirectory(file);
        this.brokerService.setPersistenceAdapter((PersistenceAdapter)adaptor);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry pe = new PolicyEntry();
        pe.setMemoryLimit(0xA00000L);
        pe.setOptimizedDispatch(true);
        pe.setProducerFlowControl(false);
        pe.setExpireMessagesPeriod(1000L);
        pe.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new FilePendingQueueMessageStoragePolicy());
        policyMap.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)pe);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(0x1400000L);
        this.brokerService.getSystemUsage().getTempUsage().setLimit(0xC800000L);
        this.brokerService.addConnector(this.ACTIVEMQ_BROKER_BIND);
        this.brokerService.start();
        new ActiveMQQueue(this.getName());
    }

    protected void tearDown() throws Exception {
        this.shutdown.set(true);
        for (Thread t : this.threads) {
            t.interrupt();
            t.join();
        }
        this.brokerService.stop();
    }
}

