/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageExpirationReaperTest {
    protected BrokerService broker;
    protected ConnectionFactory factory;
    protected ActiveMQConnection connection;
    protected String destinationName = "TEST.Q";
    protected String brokerUrl = "tcp://localhost:61616";
    protected String brokerName = "testBroker";

    @Before
    public void init() throws Exception {
        this.createBroker();
        this.factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
    }

    @After
    public void cleanUp() throws Exception {
        this.connection.close();
        this.broker.stop();
    }

    protected void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setBrokerName(this.brokerName);
        this.broker.addConnector(this.brokerUrl);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(500L);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.brokerUrl);
    }

    protected Session createSession() throws Exception {
        return this.connection.createSession(false, 1);
    }

    @Test
    public void testExpiredMessageReaping() throws Exception {
        Session producerSession = this.createSession();
        ActiveMQDestination destination = (ActiveMQDestination)producerSession.createQueue(this.destinationName);
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        producer.setTimeToLive(1000L);
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            TextMessage message = producerSession.createTextMessage("" + i);
            producer.send((Message)message);
        }
        Thread.sleep(2000L);
        DestinationViewMBean view = this.createView(destination);
        Assert.assertEquals((String)("Incorrect inflight count: " + view.getInFlightCount()), (long)0L, (long)view.getInFlightCount());
        Assert.assertEquals((String)"Incorrect queue size count", (long)0L, (long)view.getQueueSize());
        Assert.assertEquals((String)"Incorrect expired size count", (long)view.getEnqueueCount(), (long)view.getExpiredCount());
        for (int i = 0; i < 3; ++i) {
            TextMessage message = producerSession.createTextMessage("" + i);
            producer.send((Message)message);
        }
        Thread.sleep(2000L);
        Session browserSession = this.createSession();
        QueueBrowser browser = browserSession.createBrowser((Queue)destination);
        Assert.assertFalse((String)"no message in the browser", (boolean)browser.getEnumeration().hasMoreElements());
        Assert.assertEquals((String)("Wrong inFlightCount: " + view.getInFlightCount()), (long)0L, (long)view.getInFlightCount());
    }

    protected DestinationViewMBean createView(ActiveMQDestination destination) throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = destination.isQueue() ? new ObjectName(domain + ":BrokerName=" + this.brokerName + ",Type=Queue,Destination=" + this.destinationName) : new ObjectName(domain + ":BrokerName=" + this.brokerName + ",Type=Topic,Destination=" + this.destinationName);
        return (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }
}

