/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutOfOrderTestCase
extends TestCase {
    private static final Log log = LogFactory.getLog(OutOfOrderTestCase.class);
    public static final String BROKER_URL = "tcp://localhost:61616";
    private static final int PREFETCH = 10;
    private static final String CONNECTION_URL = "tcp://localhost:61616?jms.prefetchPolicy.all=10";
    public static final String QUEUE_NAME = "QUEUE";
    private static final String DESTINATION = "QUEUE?consumer.exclusive=true";
    BrokerService brokerService;
    Session session;
    Connection connection;
    int seq = 0;

    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(true);
        this.brokerService.addConnector(BROKER_URL);
        this.brokerService.deleteAllMessages();
        this.brokerService.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(CONNECTION_URL);
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.connection.close();
        this.brokerService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrder() throws Exception {
        log.info((Object)"Producing messages 0-29 . . .");
        Queue destination = this.session.createQueue(DESTINATION);
        MessageProducer messageProducer = this.session.createProducer((Destination)destination);
        try {
            for (int i = 0; i < 30; ++i) {
                TextMessage message = this.session.createTextMessage(OutOfOrderTestCase.createMessageText(i));
                message.setStringProperty("JMSXGroupID", "FOO");
                messageProducer.send((Message)message);
                log.info((Object)("sent " + this.toString((Message)message)));
            }
        }
        finally {
            messageProducer.close();
        }
        log.info((Object)"Consuming messages 0-9 . . .");
        this.consumeBatch();
        log.info((Object)"Consuming messages 10-19 . . .");
        this.consumeBatch();
        log.info((Object)"Consuming messages 20-29 . . .");
        this.consumeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeBatch() throws Exception {
        Queue destination = this.session.createQueue(DESTINATION);
        MessageConsumer messageConsumer = this.session.createConsumer((Destination)destination);
        try {
            for (int i = 0; i < 10; ++i) {
                Message message = messageConsumer.receive(1000L);
                log.info((Object)("received " + this.toString(message)));
                OutOfOrderTestCase.assertEquals((String)"Message out of order", (String)OutOfOrderTestCase.createMessageText(this.seq++), (String)((TextMessage)message).getText());
                message.acknowledge();
            }
        }
        finally {
            messageConsumer.close();
        }
    }

    private String toString(Message message) throws JMSException {
        String ret = "received message '" + ((TextMessage)message).getText() + "' - " + message.getJMSMessageID();
        if (message.getJMSRedelivered()) {
            ret = ret + " (redelivered)";
        }
        return ret;
    }

    private static String createMessageText(int index) {
        return "message #" + index;
    }
}

