/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MessageCompressionTest
extends TestCase {
    private static final String BROKER_URL = "tcp://localhost:61216";
    private static final String TEXT = "The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. ";
    protected BrokerService broker;
    private ActiveMQQueue queue;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        TransportConnector tc = new TransportConnector();
        tc.setUri(new URI(BROKER_URL));
        tc.setName("tcp");
        this.queue = new ActiveMQQueue("TEST." + System.currentTimeMillis());
        this.broker.addConnector(tc);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void testTextMessageCompression() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(true);
        this.sendTestMessage(factory, TEXT);
        ActiveMQTextMessage message = this.receiveTestMessage(factory);
        int compressedSize = message.getContent().getLength();
        factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(false);
        this.sendTestMessage(factory, TEXT);
        message = this.receiveTestMessage(factory);
        int unCompressedSize = message.getContent().getLength();
        MessageCompressionTest.assertTrue((String)("expected: compressed Size '" + compressedSize + "' < unCompressedSize '" + unCompressedSize + "'"), (compressedSize < unCompressedSize ? 1 : 0) != 0);
    }

    public void testBytesMessageCompression() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(true);
        this.sendTestBytesMessage(factory, TEXT);
        ActiveMQBytesMessage message = this.receiveTestBytesMessage(factory);
        int compressedSize = message.getContent().getLength();
        byte[] bytes = new byte[TEXT.getBytes("UTF8").length];
        message.readBytes(bytes);
        MessageCompressionTest.assertTrue((message.readBytes(new byte[255]) == -1 ? 1 : 0) != 0);
        String rcvString = new String(bytes, "UTF8");
        MessageCompressionTest.assertEquals((String)TEXT, (String)rcvString);
        factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(false);
        this.sendTestBytesMessage(factory, TEXT);
        message = this.receiveTestBytesMessage(factory);
        int unCompressedSize = message.getContent().getLength();
        MessageCompressionTest.assertTrue((String)("expected: compressed Size '" + compressedSize + "' < unCompressedSize '" + unCompressedSize + "'"), (compressedSize < unCompressedSize ? 1 : 0) != 0);
    }

    private void sendTestMessage(ActiveMQConnectionFactory factory, String message) throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        producer.send((Message)session.createTextMessage(message));
        connection.close();
    }

    private ActiveMQTextMessage receiveTestMessage(ActiveMQConnectionFactory factory) throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        ActiveMQTextMessage rc = (ActiveMQTextMessage)consumer.receive();
        connection.close();
        return rc;
    }

    private void sendTestBytesMessage(ActiveMQConnectionFactory factory, String message) throws JMSException, UnsupportedEncodingException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(message.getBytes("UTF8"));
        producer.send((Message)bytesMessage);
        connection.close();
    }

    private ActiveMQBytesMessage receiveTestBytesMessage(ActiveMQConnectionFactory factory) throws JMSException, UnsupportedEncodingException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.queue);
        ActiveMQBytesMessage rc = (ActiveMQBytesMessage)consumer.receive();
        connection.close();
        return rc;
    }
}

