/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapContainerTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(MapContainerTest.class);
    protected static final int COUNT = 10;
    protected String name = "test";
    protected Store store;
    protected MapContainer<String, String> container;
    protected Map<String, String> testMap;

    public void testBasicAllocations() throws Exception {
        String key = "key";
        Map<String, String> value = this.testMap;
        MapContainer test = this.store.getMapContainer((Object)"test", "test");
        test.put((Object)key, value);
        this.store.close();
        this.store = this.getStore();
        MapContainerTest.assertFalse((boolean)this.store.getMapContainerIds().isEmpty());
        test = this.store.getMapContainer((Object)"test", "test");
        MapContainerTest.assertEquals(value, (Object)test.get((Object)key));
    }

    public void testSize() throws Exception {
        this.container.putAll(this.testMap);
        MapContainerTest.assertTrue((this.container.size() == this.testMap.size() ? 1 : 0) != 0);
    }

    public void testIsEmpty() throws Exception {
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testClear() throws Exception {
        this.container.putAll(this.testMap);
        MapContainerTest.assertTrue((this.container.size() == this.testMap.size() ? 1 : 0) != 0);
        this.container.clear();
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testContainsKeyObject() throws Exception {
        this.container.putAll(this.testMap);
        for (Map.Entry<String, String> entry : this.testMap.entrySet()) {
            MapContainerTest.assertTrue((boolean)this.container.containsKey((Object)entry.getKey()));
        }
    }

    public void testGetObject() throws Exception {
        this.container.putAll(this.testMap);
        for (Map.Entry<String, String> entry : this.testMap.entrySet()) {
            Object value = this.container.get((Object)entry.getKey());
            MapContainerTest.assertNotNull((Object)value);
            MapContainerTest.assertTrue((boolean)value.equals(entry.getValue()));
        }
    }

    public void testContainsValueObject() throws Exception {
        this.container.putAll(this.testMap);
        for (Map.Entry<String, String> entry : this.testMap.entrySet()) {
            MapContainerTest.assertTrue((boolean)this.container.containsValue((Object)entry.getValue()));
        }
    }

    public void testPutAllMap() throws Exception {
        this.container.putAll(this.testMap);
        for (Map.Entry<String, String> entry : this.testMap.entrySet()) {
            MapContainerTest.assertTrue((boolean)this.container.containsValue((Object)entry.getValue()));
            MapContainerTest.assertTrue((boolean)this.container.containsKey((Object)entry.getKey()));
        }
    }

    public void testKeySet() throws Exception {
        this.container.putAll(this.testMap);
        Set keys = this.container.keySet();
        MapContainerTest.assertTrue((keys.size() == this.testMap.size() ? 1 : 0) != 0);
        for (String key : this.testMap.keySet()) {
            MapContainerTest.assertTrue((boolean)keys.contains(key));
            keys.remove(key);
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testValues() throws Exception {
        this.container.putAll(this.testMap);
        Collection values = this.container.values();
        MapContainerTest.assertTrue((values.size() == this.testMap.size() ? 1 : 0) != 0);
        for (String value : this.testMap.values()) {
            MapContainerTest.assertTrue((boolean)values.contains(value));
            MapContainerTest.assertTrue((boolean)values.remove(value));
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testEntrySet() throws Exception {
        this.container.putAll(this.testMap);
        Set entries = this.container.entrySet();
        MapContainerTest.assertTrue((entries.size() == this.testMap.size() ? 1 : 0) != 0);
        for (Map.Entry entry : entries) {
            MapContainerTest.assertTrue((boolean)this.testMap.containsKey(entry.getKey()));
            MapContainerTest.assertTrue((boolean)this.testMap.containsValue(entry.getValue()));
        }
    }

    public void testRemoveObject() throws Exception {
        this.container.putAll(this.testMap);
        Iterator<String> i = this.testMap.keySet().iterator();
        while (i.hasNext()) {
            this.container.remove((Object)i.next());
        }
        MapContainerTest.assertTrue((boolean)this.container.isEmpty());
    }

    public void testDuplicatesOk() throws Exception {
        this.container.put((Object)"M1", (Object)"DD");
        StoreEntry first = this.container.getFirst();
        LOG.info((Object)("First=" + first));
        MapContainerTest.assertEquals((long)-1L, (long)first.getNextItem());
        String old = (String)this.container.put((Object)"M1", (Object)"DD");
        MapContainerTest.assertNotNull((Object)old);
        MapContainerTest.assertEquals((int)1, (int)this.container.size());
        StoreEntry entry = this.container.getFirst();
        LOG.info((Object)("New First=" + entry));
        MapContainerTest.assertEquals((long)-1L, (long)entry.getNextItem());
        MapContainerTest.assertEquals((Object)first, (Object)entry);
        this.container.remove((Object)"M1");
        entry = this.container.getFirst();
        MapContainerTest.assertNull((Object)entry);
    }

    public void testDuplicatesFreeListShared() throws Exception {
        MapContainer other = this.store.getMapContainer((Object)(this.getName() + "2"), "test", true);
        other.load();
        other.put((Object)"M1", (Object)"DD");
        this.container.put((Object)"M1", (Object)"DD");
        StoreEntry batchEntry = this.container.getFirst();
        LOG.info((Object)("First=" + batchEntry));
        MapContainerTest.assertEquals((long)-1L, (long)batchEntry.getNextItem());
        other.remove((Object)"M1");
        String old = (String)this.container.put((Object)"M1", (Object)"DD");
        MapContainerTest.assertNotNull((Object)old);
        MapContainerTest.assertEquals((int)1, (int)this.container.size());
        batchEntry = this.container.refresh(batchEntry);
        MapContainerTest.assertEquals((long)-1L, (long)batchEntry.getNextItem());
        LOG.info((Object)("refreshed=" + batchEntry));
        this.container.remove((Object)"M1");
        MapContainerTest.assertNull((Object)this.container.getFirst());
        batchEntry = this.container.refresh(batchEntry);
        LOG.info((Object)("refreshed=" + batchEntry));
        MapContainerTest.assertTrue((batchEntry.getNextItem() != -1L ? 1 : 0) != 0);
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/map-container.db";
        this.store = this.getStore();
        this.container = this.store.getMapContainer((Object)this.getName(), "test", true);
        this.container.load();
        this.testMap = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            String key = "key:" + i;
            String value = "value:" + i;
            this.testMap.put(key, value);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        MapContainerTest.assertTrue((boolean)StoreFactory.delete((String)this.name));
    }
}

