/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.JournalFacade;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.async.ReadOnlyAsyncDataManager;
import org.apache.activemq.util.ByteSequence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalImplTest
extends TestCase {
    Log log = LogFactory.getLog(JournalImplTest.class);
    int size = 10240;
    int logFileCount = 2;
    File logDirectory = new File("target/dm-data2");
    private JournalFacade journal;

    protected void setUp() throws Exception {
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
        JournalImplTest.assertTrue((String)("Could not delete directory: " + this.logDirectory.getCanonicalPath()), (!this.logDirectory.exists() ? 1 : 0) != 0);
        AsyncDataManager dm = new AsyncDataManager();
        dm.setDirectory(this.logDirectory);
        dm.setMaxFileLength(65536);
        dm.start();
        this.journal = new JournalFacade(dm);
    }

    private void deleteDir(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            file.delete();
        }
        f.delete();
    }

    protected void tearDown() throws Exception {
        this.journal.close();
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
    }

    public void testLogFileCreation() throws IOException {
        RecordLocation mark = this.journal.getMark();
        JournalImplTest.assertNull((Object)mark);
    }

    public void testAppendAndRead() throws InvalidRecordLocationException, InterruptedException, IOException {
        Packet data1 = this.createPacket("Hello World 1");
        RecordLocation location1 = this.journal.write(data1, false);
        Packet data2 = this.createPacket("Hello World 2");
        RecordLocation location2 = this.journal.write(data2, false);
        Packet data3 = this.createPacket("Hello World 3");
        RecordLocation location3 = this.journal.write(data3, false);
        Packet data = this.journal.read(location2);
        JournalImplTest.assertEquals(data2, data);
        data = this.journal.read(location1);
        JournalImplTest.assertEquals(data1, data);
        data = this.journal.read(location3);
        JournalImplTest.assertEquals(data3, data);
        RecordLocation l = this.journal.getNextRecordLocation(null);
        int t = l.compareTo((Object)location1);
        JournalImplTest.assertEquals((int)0, (int)t);
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data1, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertEquals((int)0, (int)l.compareTo((Object)location2));
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data2, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertEquals((int)0, (int)l.compareTo((Object)location3));
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data3, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertNull((Object)l);
        this.log.info((Object)this.journal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyRead() throws InvalidRecordLocationException, InterruptedException, IOException {
        Packet data1 = this.createPacket("Hello World 1");
        RecordLocation location1 = this.journal.write(data1, false);
        Packet data2 = this.createPacket("Hello World 2");
        RecordLocation location2 = this.journal.write(data2, false);
        Packet data3 = this.createPacket("Hello World 3");
        RecordLocation location3 = this.journal.write(data3, false);
        Packet packet = this.journal.read(location2);
        JournalImplTest.assertEquals(data2, packet);
        packet = this.journal.read(location1);
        JournalImplTest.assertEquals(data1, packet);
        packet = this.journal.read(location3);
        JournalImplTest.assertEquals(data3, packet);
        ArrayList<File> data = new ArrayList<File>();
        data.add(this.logDirectory);
        ReadOnlyAsyncDataManager rodm = new ReadOnlyAsyncDataManager(data);
        rodm.start();
        try {
            Location curr = rodm.getFirstLocation();
            while (curr != null) {
                ByteSequence bs = rodm.read(curr);
                JournalImplTest.assertNotNull((Object)bs);
                curr = rodm.getNextLocation(curr);
            }
        }
        finally {
            rodm.close();
        }
    }

    public void testCanReadFromArchivedLogFile() throws InvalidRecordLocationException, InterruptedException, IOException {
        JournalFacade.RecordLocationFacade pos;
        Packet data1 = this.createPacket("Hello World 1");
        JournalFacade.RecordLocationFacade location1 = (JournalFacade.RecordLocationFacade)this.journal.write(data1, false);
        int counter = 0;
        do {
            Packet p = this.createPacket("<<<data>>>");
            pos = (JournalFacade.RecordLocationFacade)this.journal.write(p, false);
            if (counter++ % 1000 != 0) continue;
            this.journal.setMark((RecordLocation)pos, false);
        } while (pos.getLocation().getDataFileId() < 5);
        Packet data = this.journal.read((RecordLocation)location1);
        JournalImplTest.assertEquals(data1, data);
    }

    private Packet createPacket(String string) {
        return new ByteArrayPacket(string.getBytes());
    }

    public static void assertEquals(Packet arg0, Packet arg1) {
        JournalImplTest.assertEquals(arg0.sliceAsBytes(), arg1.sliceAsBytes());
    }

    public static void assertEquals(byte[] arg0, byte[] arg1) {
        if (arg0 == null ^ arg1 == null) {
            JournalImplTest.fail((String)("Not equal: " + arg0 + " != " + arg1));
        }
        if (arg0 == null) {
            return;
        }
        if (arg0.length != arg1.length) {
            JournalImplTest.fail((String)("Array lenght not equal: " + arg0.length + " != " + arg1.length));
        }
        for (int i = 0; i < arg0.length; ++i) {
            if (arg0[i] == arg1[i]) continue;
            JournalImplTest.fail((String)("Array item not equal at index " + i + ": " + arg0[i] + " != " + arg1[i]));
        }
    }
}

