/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.File;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.util.IOHelper;

public abstract class IndexBenchmark
extends TestCase {
    private static final long SAMPLE_DURATION = Integer.parseInt(System.getProperty("SAMPLES_DURATION", "5000"));
    private static final long SAMPLES = Integer.parseInt(System.getProperty("SAMPLES", "" + 60000L / SAMPLE_DURATION));
    private static final int INDEX_COUNT = Integer.parseInt(System.getProperty("INDEX_COUNT", "1"));
    private static final int INDEX_PRE_LOAD_COUNT = Integer.parseInt(System.getProperty("INDEX_PRE_LOAD_COUNT", "" + 10000 / INDEX_COUNT));
    protected File ROOT_DIR;
    protected final HashMap<String, Index> indexes = new HashMap();
    protected IndexManager indexManager;

    public void setUp() throws Exception {
        this.ROOT_DIR = new File(IOHelper.getDefaultDataDirectory());
        IOHelper.mkdirs((File)this.ROOT_DIR);
        IOHelper.deleteChildren((File)this.ROOT_DIR);
        this.indexManager = new IndexManager(this.ROOT_DIR, ((Object)((Object)this)).getClass().getName(), "rw", null, new AtomicLong());
    }

    protected void tearDown() throws Exception {
        for (Index i : this.indexes.values()) {
            try {
                i.unload();
            }
            catch (Throwable throwable) {}
        }
        this.indexManager.close();
    }

    protected abstract Index createIndex(File var1, String var2) throws Exception;

    private synchronized Index openIndex(String name) throws Exception {
        Index index = this.indexes.get(name);
        if (index == null) {
            index = this.createIndex(this.ROOT_DIR, name);
            index.load();
            this.indexes.put(name, index);
        }
        return index;
    }

    public void testLoad() throws Exception {
        Producer[] producers = new Producer[INDEX_COUNT];
        Consumer[] consumers = new Consumer[INDEX_COUNT];
        final CountDownLatch preloadCountDown = new CountDownLatch(INDEX_COUNT);
        final AtomicLong producedRecords = new AtomicLong();
        final AtomicLong consumedRecords = new AtomicLong();
        System.out.println("Starting: " + INDEX_COUNT + " producers");
        for (int i = 0; i < INDEX_COUNT; ++i) {
            producers[i] = new Producer("test-" + i){
                private boolean prelaodDone;

                public void onProduced(long counter) {
                    if (!this.prelaodDone && counter >= (long)INDEX_PRE_LOAD_COUNT) {
                        this.prelaodDone = true;
                        preloadCountDown.countDown();
                    }
                    producedRecords.incrementAndGet();
                }
            };
            producers[i].start();
        }
        long start = System.currentTimeMillis();
        System.out.println("Waiting for each producer create " + INDEX_PRE_LOAD_COUNT + " records before starting the consumers.");
        preloadCountDown.await();
        long end = System.currentTimeMillis();
        System.out.println("Preloaded " + INDEX_PRE_LOAD_COUNT * INDEX_COUNT + " records at " + (float)(INDEX_PRE_LOAD_COUNT * INDEX_COUNT) * 1000.0f / (float)(end - start) + " records/sec");
        System.out.println("Starting: " + INDEX_COUNT + " consumers");
        for (int i = 0; i < INDEX_COUNT; ++i) {
            consumers[i] = new Consumer("test-" + i){

                public void onConsumed(long counter) {
                    consumedRecords.incrementAndGet();
                }
            };
            consumers[i].start();
        }
        long sample_start = System.currentTimeMillis();
        System.out.println("Taking " + SAMPLES + " performance samples every " + SAMPLE_DURATION + " ms");
        System.out.println("time (s), produced, produce rate (r/s), consumed, consume rate (r/s), used memory (k)");
        producedRecords.set(0L);
        consumedRecords.set(0L);
        int i = 0;
        while ((long)i < SAMPLES) {
            start = System.currentTimeMillis();
            Thread.sleep(SAMPLE_DURATION);
            end = System.currentTimeMillis();
            long p = producedRecords.getAndSet(0L);
            long c = consumedRecords.getAndSet(0L);
            long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            System.out.println((float)(end - sample_start) / 1000.0f + ", " + p + ", " + (float)p * 1000.0f / (float)(end - start) + ", " + c + ", " + (float)c * 1000.0f / (float)(end - start) + ", " + usedMemory / 1024L);
            ++i;
        }
        System.out.println("Samples done... Shutting down the producers and consumers...");
        for (i = 0; i < INDEX_COUNT; ++i) {
            producers[i].shutdown();
            consumers[i].shutdown();
        }
        for (i = 0; i < INDEX_COUNT; ++i) {
            producers[i].join(5000L);
            consumers[i].join(5000L);
        }
        System.out.println("Shutdown.");
    }

    class Consumer
    extends Thread {
        private final String name;
        AtomicBoolean shutdown;

        public Consumer(String name) {
            super("Consumer: " + name);
            this.shutdown = new AtomicBoolean();
            this.name = name;
        }

        public void shutdown() {
            this.shutdown.set(true);
        }

        public void run() {
            try {
                Index index = IndexBenchmark.this.openIndex(this.name);
                long counter = 0L;
                while (!this.shutdown.get()) {
                    long c = counter;
                    String key = "a-long-message-id-like-key-" + c;
                    StoreEntry record = index.get((Object)key);
                    if (record != null) {
                        index.remove((Object)key);
                        this.onConsumed(counter++);
                        continue;
                    }
                    Thread.sleep(0L);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void onConsumed(long counter) {
        }
    }

    class Producer
    extends Thread {
        private final String name;
        AtomicBoolean shutdown;

        public Producer(String name) {
            super("Producer: " + name);
            this.shutdown = new AtomicBoolean();
            this.name = name;
        }

        public void shutdown() {
            this.shutdown.set(true);
        }

        public void run() {
            try {
                IndexItem value = IndexBenchmark.this.indexManager.createNewIndex();
                IndexBenchmark.this.indexManager.storeIndex(value);
                Index index = IndexBenchmark.this.openIndex(this.name);
                long counter = 0L;
                while (!this.shutdown.get()) {
                    long c = counter;
                    String key = "a-long-message-id-like-key-" + c;
                    index.store((Object)key, (StoreEntry)value);
                    this.onProduced(counter++);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void onProduced(long counter) {
        }
    }
}

